/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.EventExporter;
import com.sonatype.nexus.analytics.EventRecorder;
import com.sonatype.nexus.analytics.EventStore;
import com.sonatype.nexus.analytics.internal.SingleFileEventWriter;
import com.sonatype.nexus.analytics.internal.SubmitTask;
import com.yammer.metrics.annotation.Timed;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.util.Tokens;
import org.sonatype.nexus.wonderland.AuthTicketService;
import org.sonatype.nexus.wonderland.DownloadService;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.common.error.WebApplicationMessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@Path(value="/analytics/events")
public class EventsResource
extends ComponentSupport
implements Resource,
GroovyObject {
    private static final String RESOURCE_URI = "/analytics/events";
    private final EventRecorder eventRecorder;
    private final EventStore eventStore;
    private final EventExporter eventExporter;
    private final NexusScheduler nexusScheduler;
    private final Provider<SubmitTask> submitTaskFactory;
    private final DownloadService downloadService;
    private final AuthTicketService authTickets;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    @Inject
    public EventsResource(EventRecorder eventRecorder, EventStore eventStore, EventExporter eventExporter, NexusScheduler nexusScheduler, Provider<SubmitTask> provider, DownloadService downloadService, AuthTicketService authTicketService) {
        void authTickets;
        void downloadService2;
        void submitTaskFactory;
        void nexusScheduler2;
        void eventExporter2;
        void eventStore2;
        void eventRecorder2;
        MetaClass metaClass;
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callStatic(Preconditions.class, (Object)eventRecorder2);
        this.eventRecorder = (EventRecorder)ScriptBytecodeAdapter.castToType((Object)object, EventRecorder.class);
        Object object2 = callSiteArray[1].callStatic(Preconditions.class, (Object)eventStore2);
        this.eventStore = (EventStore)ScriptBytecodeAdapter.castToType((Object)object2, EventStore.class);
        Object object3 = callSiteArray[2].callStatic(Preconditions.class, (Object)eventExporter2);
        this.eventExporter = (EventExporter)ScriptBytecodeAdapter.castToType((Object)object3, EventExporter.class);
        Object object4 = callSiteArray[3].callStatic(Preconditions.class, (Object)nexusScheduler2);
        this.nexusScheduler = (NexusScheduler)ScriptBytecodeAdapter.castToType((Object)object4, NexusScheduler.class);
        Object object5 = callSiteArray[4].callStatic(Preconditions.class, (Object)submitTaskFactory);
        this.submitTaskFactory = (Provider)ScriptBytecodeAdapter.castToType((Object)object5, Provider.class);
        Object object6 = callSiteArray[5].callStatic(Preconditions.class, (Object)downloadService2);
        this.downloadService = (DownloadService)ScriptBytecodeAdapter.castToType((Object)object6, DownloadService.class);
        Object object7 = callSiteArray[6].callStatic(Preconditions.class, (Object)authTickets);
        this.authTickets = (AuthTicketService)ScriptBytecodeAdapter.castToType((Object)object7, AuthTicketService.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"nexus:analytics"})
    @Timed
    public Map list(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="-1") int limit) {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{start, limit}, new String[]{"Listing events; start=", " limit=", ""}));
        List events = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Integer count = 0;
        KeyValueIterable eventEntries = null;
        try {
            Object object = callSiteArray[9].call((Object)this.eventStore, (Object)start, (Object)limit);
            eventEntries = (KeyValueIterable)ScriptBytecodeAdapter.castToType((Object)object, KeyValueIterable.class);
            KeyValuePair entry = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)eventEntries), Iterator.class);
            while (iterator.hasNext()) {
                entry = (KeyValuePair)ScriptBytecodeAdapter.castToType(iterator.next(), KeyValuePair.class);
                Object event = callSiteArray[11].callGetProperty((Object)entry);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGetProperty(event))) {
                    String string = "stripped";
                    ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)event, (String)"sessionId");
                }
                callSiteArray[13].call((Object)events, event);
                Integer n = count;
                callSiteArray[14].call((Object)n);
                if (!(limit > 0 && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)count, (Object)limit))) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            if (BytecodeInterface8.isOrigZ() && !__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                if (!ScriptBytecodeAdapter.compareNotEqual(eventEntries, null)) throw throwable;
                callSiteArray[18].call((Object)eventEntries);
                throw throwable;
            }
            if (!ScriptBytecodeAdapter.compareNotEqual(eventEntries, null)) throw throwable;
            callSiteArray[17].call(eventEntries);
            throw throwable;
        }
        if (BytecodeInterface8.isOrigZ() && !__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)eventEntries, null)) return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"count", callSiteArray[19].call((Object)events), "total", callSiteArray[20].call((Object)this.eventStore), "events", events});
        } else {
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)eventEntries, null)) return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"count", callSiteArray[19].call((Object)events), "total", callSiteArray[20].call((Object)this.eventStore), "events", events});
            callSiteArray[15].call((Object)eventEntries);
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"count", callSiteArray[19].call((Object)events), "total", callSiteArray[20].call((Object)this.eventStore), "events", events});
        }
        callSiteArray[16].call((Object)eventEntries);
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"count", callSiteArray[19].call((Object)events), "total", callSiteArray[20].call((Object)this.eventStore), "events", events});
    }

    @DELETE
    @RequiresPermissions(value={"nexus:analytics"})
    @Timed
    public void clear() {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        callSiteArray[21].call((Object)this.eventStore);
    }

    @POST
    @Path(value="submit")
    @RequiresPermissions(value={"nexus:analytics"})
    @Timed
    public void submit(@QueryParam(value="t") String authTicket) {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)authTicket)) {
            throw (Throwable)callSiteArray[22].callConstructor(WebApplicationMessageException.class, callSiteArray[23].callGetProperty(Response.Status.class), (Object)"Missing authentication ticket");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)this.authTickets, callSiteArray[25].call(Tokens.class, (Object)authTicket)))) {
            throw (Throwable)callSiteArray[26].callConstructor(WebApplicationMessageException.class, callSiteArray[27].callGetProperty(Response.Status.class), (Object)"Invalid authentication ticket");
        }
        Object task = callSiteArray[28].call(this.submitTaskFactory);
        callSiteArray[29].call(task, callSiteArray[30].callGetProperty(SubmitTask.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)true, String.class)), String.class));
        Object scheduled = callSiteArray[31].call((Object)this.nexusScheduler, (Object)"Manually submit analytics events", task);
        callSiteArray[32].call(callSiteArray[33].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{scheduled}, new String[]{"Scheduled task: ", ""}));
    }

    @POST
    @Path(value="export")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"nexus:analytics"})
    @Timed
    public Map export() {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        SingleFileEventWriter writer = (SingleFileEventWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(SingleFileEventWriter.class), SingleFileEventWriter.class);
        callSiteArray[35].call((Object)this.eventExporter, (Object)writer, (Object)false);
        File toBeDownloaded = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call((Object)this.downloadService, callSiteArray[37].callGetProperty((Object)writer), callSiteArray[38].call(callSiteArray[39].call((Object)this.downloadService, (Object)"analytics-"), (Object)".zip")), File.class);
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"file", callSiteArray[40].callGetProperty((Object)toBeDownloaded), "name", callSiteArray[41].callGetProperty((Object)toBeDownloaded), "size", callSiteArray[42].call((Object)toBeDownloaded)});
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public void append(List<EventData> events) {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].callGetProperty((Object)this.eventRecorder))) {
            callSiteArray[44].call(callSiteArray[45].callGroovyObjectGetProperty((Object)this), (Object)"Ignoring events; recording is disabled");
            return;
        }
        callSiteArray[46].call(events, (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _append_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _append_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _append_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _append_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _append_closure1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _append_closure1.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "record";
                stringArray[1] = "eventRecorder";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _append_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_append_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _append_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(EventsResource.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, EventsResource.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField(EventsResource.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != EventsResource.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = EventsResource.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        EventsResource.__$swapInit();
    }

    public static final String getRESOURCE_URI() {
        return RESOURCE_URI;
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ Logger super$2$createLogger() {
        return super.createLogger();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkNotNull";
        stringArray[1] = "checkNotNull";
        stringArray[2] = "checkNotNull";
        stringArray[3] = "checkNotNull";
        stringArray[4] = "checkNotNull";
        stringArray[5] = "checkNotNull";
        stringArray[6] = "checkNotNull";
        stringArray[7] = "debug";
        stringArray[8] = "log";
        stringArray[9] = "iterator";
        stringArray[10] = "iterator";
        stringArray[11] = "value";
        stringArray[12] = "sessionId";
        stringArray[13] = "leftShift";
        stringArray[14] = "next";
        stringArray[15] = "close";
        stringArray[16] = "close";
        stringArray[17] = "close";
        stringArray[18] = "close";
        stringArray[19] = "size";
        stringArray[20] = "approximateSize";
        stringArray[21] = "clear";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "BAD_REQUEST";
        stringArray[24] = "redeemTicket";
        stringArray[25] = "decodeBase64String";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "FORBIDDEN";
        stringArray[28] = "get";
        stringArray[29] = "addParameter";
        stringArray[30] = "SKIP_RESUBMISSION";
        stringArray[31] = "submit";
        stringArray[32] = "debug";
        stringArray[33] = "log";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "export";
        stringArray[36] = "move";
        stringArray[37] = "file";
        stringArray[38] = "plus";
        stringArray[39] = "uniqueName";
        stringArray[40] = "absolutePath";
        stringArray[41] = "name";
        stringArray[42] = "size";
        stringArray[43] = "enabled";
        stringArray[44] = "warn";
        stringArray[45] = "log";
        stringArray[46] = "each";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[47];
        EventsResource.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(EventsResource.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = EventsResource.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

