/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.analytics.EventExporter;
import com.sonatype.nexus.analytics.EventSubmitter;
import com.sonatype.nexus.analytics.internal.MultiFileEventWriter;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.scheduling.NexusTaskSupport;

@Named(value="SubmitTask")
public class SubmitTask
extends NexusTaskSupport {
    public static final String ID = "SubmitTask";
    public static final String SKIP_RESUBMISSION = "skipResubmission";
    private final EventExporter eventExporter;
    private final ApplicationDirectories directories;
    private EventSubmitter eventSubmitter;

    @Inject
    public SubmitTask(EventExporter eventExporter, EventSubmitter eventSubmitter, ApplicationDirectories directories) {
        this.eventExporter = (EventExporter)Preconditions.checkNotNull((Object)eventExporter);
        this.eventSubmitter = (EventSubmitter)Preconditions.checkNotNull((Object)eventSubmitter);
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories, (Object)"directories");
    }

    protected String getMessage() {
        return "Submitting analytics events";
    }

    protected void execute() throws Exception {
        File uploadsDir = this.directories.getWorkDirectory("analytics-upload");
        if (!Boolean.valueOf(this.getParameter(SKIP_RESUBMISSION)).booleanValue()) {
            Collection filesToUpload = FileUtils.listFiles((File)uploadsDir, (String[])new String[]{"zip"}, (boolean)false);
            for (File file : filesToUpload) {
                this.logger.debug("Re-submitting file {}", (Object)file);
                this.eventSubmitter.submit(file);
                Files.delete(file.toPath());
            }
        }
        ArrayList uploadFiles = Lists.newArrayList();
        MultiFileEventWriter writer = new MultiFileEventWriter();
        this.eventExporter.export(writer, true);
        for (File file : writer.getFiles()) {
            File toUpload = new File(uploadsDir, file.getName());
            Files.move(file.toPath(), toUpload.toPath(), new CopyOption[0]);
            uploadFiles.add(toUpload);
        }
        for (File file : uploadFiles) {
            this.eventSubmitter.submit(file);
            Files.delete(file.toPath());
        }
    }
}

