/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.EventHeader;
import com.sonatype.nexus.analytics.EventWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class SingleFileEventWriter
extends ComponentSupport
implements EventWriter {
    private static final int DEFAULT_MAX_EVENTS_PER_ENTRY = SystemPropertiesHelper.getInteger((String)(String.valueOf(SingleFileEventWriter.class.getName()) + ".maxEventsPerEntry"), (int)10000);
    @VisibleForTesting
    static final String EVENTS_ENTRY_FORMAT = "events-%d.json";
    @VisibleForTesting
    static final String HEADER_ENTRY_NAME = "header.json";
    private final File file;
    private final JsonFactory jsonFactory;
    private int maxEventsPerEntry = DEFAULT_MAX_EVENTS_PER_ENTRY;
    private ZipOutputStream output;
    private ZipEntry currentEntry;
    private int entryCount = 0;
    private int eventCount = 0;
    private JsonGenerator jsonGenerator;

    public SingleFileEventWriter(File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.jsonFactory = mapper.getFactory();
    }

    public SingleFileEventWriter() throws IOException {
        this(File.createTempFile("analytics-", ".zip").getCanonicalFile());
    }

    @VisibleForTesting
    void setMaxEventsPerEntry(int maxEventsPerEntry) {
        Preconditions.checkArgument((maxEventsPerEntry >= 1 ? 1 : 0) != 0);
        this.maxEventsPerEntry = maxEventsPerEntry;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "file=" + this.file + '}';
    }

    @Override
    public void open(EventHeader header) throws IOException {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkState((this.output == null ? 1 : 0) != 0, (Object)"Already opened");
        this.log.debug("Opening for write: {}", (Object)this.file);
        this.output = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        this.output.setLevel(-1);
        this.writeHeader(header);
    }

    private void writeHeader(EventHeader header) throws IOException {
        ZipEntry zipEntry = new ZipEntry(HEADER_ENTRY_NAME);
        this.output.putNextEntry(zipEntry);
        JsonGenerator generator = this.jsonFactory.createGenerator((OutputStream)this.output);
        generator.writeObject((Object)header);
        generator.flush();
        this.output.closeEntry();
    }

    @Override
    public void write(EventData data) throws IOException {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkState((this.output != null ? 1 : 0) != 0, (Object)"Not opened");
        this.maybeOpenEntry();
        this.jsonGenerator.writeObject((Object)data);
        ++this.eventCount;
    }

    private void maybeOpenEntry() throws IOException {
        if (this.currentEntry == null || this.eventCount > this.maxEventsPerEntry) {
            this.maybeCloseEntry();
            ++this.entryCount;
            ZipEntry entry = new ZipEntry(String.format(EVENTS_ENTRY_FORMAT, this.entryCount));
            this.log.trace("Opening entry: {}", (Object)entry.getName());
            this.output.putNextEntry(entry);
            this.jsonGenerator = this.jsonFactory.createGenerator((OutputStream)this.output);
            this.jsonGenerator.writeStartArray();
            this.currentEntry = entry;
            this.eventCount = 0;
        }
    }

    private void maybeCloseEntry() throws IOException {
        if (this.currentEntry != null) {
            this.log.trace("Closing entry: {}", (Object)this.currentEntry.getName());
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.flush();
            this.output.closeEntry();
            this.currentEntry = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            this.log.debug("Closing");
            this.maybeCloseEntry();
            this.output.close();
            this.output = null;
        }
        this.jsonGenerator = null;
    }
}

