/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.EventDataBuilder;
import com.sonatype.nexus.analytics.EventRecorder;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class RestRequestCollector
extends ComponentSupport
implements Filter {
    private final EventRecorder recorder;

    @Inject
    public RestRequestCollector(EventRecorder recorder) {
        this.recorder = (EventRecorder)Preconditions.checkNotNull((Object)recorder);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean ui;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        EventDataBuilder builder = null;
        boolean bl = ui = httpRequest.getHeader("X-Nexus-UI") != null;
        if (this.recorder.isEnabled()) {
            builder = new EventDataBuilder("REST").set("method", httpRequest.getMethod()).set("path", this.getPath(httpRequest)).set("ui", ui);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (builder != null) {
                builder.set("status", httpResponse.getStatus());
                this.recorder.record(builder.build());
            }
        }
    }

    private String getPath(HttpServletRequest request) {
        String context = request.getContextPath();
        String path = request.getRequestURI();
        if (path.startsWith(context)) {
            path = path.substring(context.length(), path.length());
        }
        return path;
    }
}

