/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.EventHeader;
import com.sonatype.nexus.analytics.EventWriter;
import com.sonatype.nexus.analytics.internal.SingleFileEventWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class MultiFileEventWriter
extends ComponentSupport
implements EventWriter {
    private static final int DEFAULT_MAX_EVENTS_PER_FILE = SystemPropertiesHelper.getInteger((String)(String.valueOf(MultiFileEventWriter.class.getName()) + ".maxEventsPerFile"), (int)1000000);
    public static final String ATTR_MULTIFILE_ID = "multifile.id";
    public static final String ATTR_MULTIFILE_PART = "multifile.part";
    private final List<File> files = Lists.newArrayList();
    private int maxEventsPerFile = DEFAULT_MAX_EVENTS_PER_FILE;
    private boolean open;
    private EventHeader header;
    private int eventCount = 0;
    private int fileCount = 0;
    private SingleFileEventWriter currentWriter;

    @VisibleForTesting
    void setMaxEventsPerFile(int maxEventsPerFile) {
        Preconditions.checkArgument((maxEventsPerFile >= 1 ? 1 : 0) != 0);
        this.maxEventsPerFile = maxEventsPerFile;
    }

    public List<File> getFiles() {
        return this.files;
    }

    @Override
    public void open(EventHeader header) throws IOException {
        Preconditions.checkNotNull((Object)header);
        Preconditions.checkState((!this.open ? 1 : 0) != 0, (Object)"Already opened");
        this.header = header.copy();
        this.header.getAttributes().put(ATTR_MULTIFILE_ID, UUID.randomUUID().toString());
        this.open = true;
    }

    @Override
    public void write(EventData data) throws IOException {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkState((boolean)this.open, (Object)"Not opened");
        this.maybeOpenWriter();
        this.currentWriter.write(data);
        ++this.eventCount;
    }

    private void maybeOpenWriter() throws IOException {
        if (this.currentWriter == null || this.eventCount > this.maxEventsPerFile) {
            this.maybeCloseWriter();
            SingleFileEventWriter writer = this.createWriter();
            this.log.debug("Opening writer: {}", (Object)writer);
            ++this.fileCount;
            this.header.getAttributes().put(ATTR_MULTIFILE_PART, String.valueOf(this.fileCount));
            writer.open(this.header);
            this.currentWriter = writer;
            this.eventCount = 0;
        }
    }

    @VisibleForTesting
    SingleFileEventWriter createWriter() throws IOException {
        return new SingleFileEventWriter();
    }

    private void maybeCloseWriter() throws IOException {
        if (this.currentWriter != null) {
            this.log.debug("Closing writer: {}", (Object)this.currentWriter);
            this.currentWriter.close();
            File file = this.currentWriter.getFile();
            this.files.add(file);
            this.currentWriter = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.maybeCloseWriter();
            this.open = false;
        }
    }
}

