/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.EventStore;
import io.kazuki.v0.internal.v2schema.Attribute;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.store.journal.JournalStore;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.schema.SchemaStore;
import io.kazuki.v0.store.schema.TypeValidation;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Named
@Singleton
public class EventStoreImpl
extends LifecycleSupport
implements EventStore {
    private final JournalStore store;
    private final SchemaStore schemaStore;
    private final Lifecycle lifecycle;

    @Inject
    public EventStoreImpl(@Named(value="nexusanalytics") JournalStore store, @Named(value="nexusanalytics") SchemaStore schemaStore, @Named(value="nexusanalytics") Lifecycle lifecycle) {
        this.store = (JournalStore)Preconditions.checkNotNull((Object)store);
        this.schemaStore = (SchemaStore)Preconditions.checkNotNull((Object)schemaStore);
        this.lifecycle = (Lifecycle)Preconditions.checkNotNull((Object)lifecycle);
    }

    protected void doStart() throws Exception {
        this.lifecycle.init();
        this.lifecycle.start();
        if (this.schemaStore.retrieveSchema("event_data") == null) {
            Schema schema = new Schema((List)ImmutableList.of((Object)new Attribute("type", Attribute.Type.UTF8_SMALLSTRING, null, Boolean.valueOf(false)), (Object)new Attribute("timestamp", Attribute.Type.I64, null, Boolean.valueOf(true)), (Object)new Attribute("sequence", Attribute.Type.I64, null, Boolean.valueOf(true)), (Object)new Attribute("userId", Attribute.Type.UTF8_SMALLSTRING, null, Boolean.valueOf(true)), (Object)new Attribute("sessionId", Attribute.Type.UTF8_SMALLSTRING, null, Boolean.valueOf(true)), (Object)new Attribute("attributes", Attribute.Type.MAP, null, Boolean.valueOf(true))));
            this.schemaStore.createSchema("event_data", schema);
        }
    }

    protected void doStop() throws Exception {
        this.lifecycle.stop();
        this.lifecycle.shutdown();
    }

    public JournalStore getJournalStore() {
        this.ensureStarted();
        return this.store;
    }

    @Override
    public void add(EventData data) throws Exception {
        Preconditions.checkNotNull((Object)data);
        this.ensureStarted();
        this.store.append("event_data", EventData.class, (Object)data, TypeValidation.STRICT);
    }

    @Override
    public void clear() throws Exception {
        this.ensureStarted();
        this.store.clear();
        this.log.debug("Cleared");
    }

    @Override
    public long approximateSize() throws Exception {
        this.ensureStarted();
        return this.store.approximateSize();
    }

    @Override
    public KeyValueIterable<KeyValuePair<EventData>> iterator(long offset, @Nullable Long limit) throws Exception {
        this.ensureStarted();
        return this.store.entriesRelative("event_data", EventData.class, Long.valueOf(offset), limit);
    }
}

