/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.EventRecorder;
import com.sonatype.nexus.analytics.EventStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class EventRecorderImpl
extends ComponentSupport
implements EventRecorder {
    private final EventStore store;
    private volatile boolean enabled = false;

    @Inject
    public EventRecorderImpl(EventStore store) {
        this.store = (EventStore)Preconditions.checkNotNull((Object)store);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.log.debug("Enabled: {}", (Object)enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void record(EventData data) {
        Preconditions.checkNotNull((Object)data);
        if (!this.enabled) {
            this.log.warn("Attempting to record analytics data when collection is disabled; ignoring");
            return;
        }
        this.log.debug("Record: {}", (Object)data);
        try {
            this.store.add(data);
        }
        catch (Exception e) {
            this.log.warn("Failed to record event data", (Throwable)e);
        }
    }
}

