/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sonatype.nexus.analytics.Anonymizer;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.EventExporter;
import com.sonatype.nexus.analytics.EventWriter;
import com.sonatype.nexus.analytics.internal.EventHeaderFactory;
import com.sonatype.nexus.analytics.internal.EventStoreImpl;
import io.kazuki.v0.store.journal.JournalStore;
import io.kazuki.v0.store.journal.PartitionInfo;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.time.StopWatch;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class EventExporterImpl
extends ComponentSupport
implements EventExporter {
    private final EventStoreImpl eventStore;
    private final Anonymizer anonymizer;
    private final EventHeaderFactory headerFactory;
    private final ReentrantLock exportLock = new ReentrantLock();

    @Inject
    public EventExporterImpl(EventStoreImpl eventStore, EventHeaderFactory headerFactory, Anonymizer anonymizer) {
        this.eventStore = (EventStoreImpl)Preconditions.checkNotNull((Object)eventStore);
        this.anonymizer = (Anonymizer)Preconditions.checkNotNull((Object)anonymizer);
        this.headerFactory = (EventHeaderFactory)((Object)Preconditions.checkNotNull((Object)((Object)headerFactory)));
    }

    @Override
    public void export(EventWriter writer, boolean dropAfterExport) throws Exception {
        try {
            Preconditions.checkState((boolean)this.exportLock.tryLock(), (Object)"Export already in progress");
            this.doExport(writer, dropAfterExport);
        }
        finally {
            if (this.exportLock.isHeldByCurrentThread()) {
                this.exportLock.unlock();
            }
        }
    }

    private void doExport(EventWriter writer, boolean dropAfterExport) throws Exception {
        this.log.info("Exporting; dropAfterExport: {}", (Object)dropAfterExport);
        StopWatch watch = new StopWatch();
        watch.start();
        JournalStore journal = this.eventStore.getJournalStore();
        journal.closeActivePartition();
        AnonymizerHelper anonymizerHelper = new AnonymizerHelper();
        long eventCount = 0L;
        int partitionCount = 0;
        writer.open(this.headerFactory.create());
        try {
            Throwable throwable = null;
            Object var10_10 = null;
            try (KeyValueIterable partitions = journal.getAllPartitions();){
                for (PartitionInfo partition : partitions) {
                    if (!partition.isClosed()) {
                        break;
                    }
                    ++partitionCount;
                    Throwable throwable2 = null;
                    Object var15_17 = null;
                    try (KeyValueIterable iter = journal.entriesRelative("event_data", EventData.class, Long.valueOf(0L), Long.valueOf(partition.getSize()));){
                        for (KeyValuePair entry : iter) {
                            writer.write(anonymizerHelper.anonymize((EventData)entry.getValue()));
                            ++eventCount;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    if (!dropAfterExport) continue;
                    journal.dropPartition(partition.getPartitionId());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            writer.close();
        }
        this.log.info("Exported {} partitions, {} events; took: {}", new Object[]{partitionCount, eventCount, watch});
    }

    private class AnonymizerHelper {
        private final Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(200L).build();

        private AnonymizerHelper() {
        }

        public EventData anonymize(EventData event) {
            event.setUserId(this.anonymize(event.getUserId()));
            event.setSessionId(this.anonymize(event.getSessionId()));
            return event;
        }

        private String anonymize(String text) {
            if (text == null) {
                return null;
            }
            String result = (String)this.cache.getIfPresent((Object)text);
            if (result == null) {
                result = EventExporterImpl.this.anonymizer.anonymize(text);
                EventExporterImpl.this.log.debug("Anonymized {} -> {}", (Object)text, (Object)result);
                this.cache.put((Object)text, (Object)result);
            }
            return result;
        }
    }
}

