/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NonNls;
import org.sonatype.nexus.capability.support.CapabilityDescriptorSupport;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

@Named(value="analytics.collection")
@Singleton
public class CollectionCapabilityDescriptor
extends CapabilityDescriptorSupport
implements Taggable {
    @NonNls
    public static final String TYPE_ID = "analytics.collection";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"analytics.collection");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final FormField hostId = new StringTextFormField("hostId", messages.hostIdLabel(), messages.hostIdHelp(), true);
    private final FormField salt = new StringTextFormField("salt", messages.saltLabel(), messages.saltHelp(), true);

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return Arrays.asList(this.hostId, this.salt);
    }

    public Validator validator() {
        return this.validators().capability().uniquePer(TYPE, new String[0]);
    }

    protected String renderAbout() throws Exception {
        return this.render("analytics.collection-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Analytics")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Analytics: Collection")
        public String name();

        @MessageBundle.DefaultMessage(value="Host Identifier")
        public String hostIdLabel();

        @MessageBundle.DefaultMessage(value="Random identifier to group analytics event data for a specific host.")
        public String hostIdHelp();

        @MessageBundle.DefaultMessage(value="Anonymization Salt")
        public String saltLabel();

        @MessageBundle.DefaultMessage(value="Random data used to anonymize data.")
        public String saltHelp();
    }
}

