/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.capability.support.CapabilityConfigurationSupport;

public class CollectionCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String HOST_ID = "hostId";
    public static final String SALT = "salt";
    private String hostId;
    private String salt;

    public CollectionCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.hostId = properties.get(HOST_ID);
        this.salt = properties.get(SALT);
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getSalt() {
        return this.salt;
    }

    public byte[] getSaltBytes() {
        Preconditions.checkState((this.salt != null ? 1 : 0) != 0);
        return this.salt.getBytes(Charsets.UTF_8);
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(HOST_ID, this.hostId);
        props.put(SALT, this.salt);
        return props;
    }

    public String toString() {
        return "CollectionCapabilityConfiguration{hostId='" + this.hostId + '\'' + ", salt='" + this.salt + '\'' + '}';
    }
}

