/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.internal.AnonymizerImpl;
import com.sonatype.nexus.analytics.internal.CollectionCapabilityConfiguration;
import com.sonatype.nexus.analytics.internal.EventHeaderFactory;
import com.sonatype.nexus.analytics.internal.EventRecorderImpl;
import com.sonatype.nexus.analytics.internal.EventStoreImpl;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.support.CapabilitySupport;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;
import org.sonatype.sisu.goodies.template.TemplateParameters;

@Named(value="analytics.collection")
public class CollectionCapability
extends CapabilitySupport<CollectionCapabilityConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final EventStoreImpl store;
    private final EventRecorderImpl recorder;
    private final AnonymizerImpl anonymizer;
    private final EventHeaderFactory headerFactory;

    @Inject
    public CollectionCapability(EventStoreImpl store, EventRecorderImpl recorder, AnonymizerImpl anonymizer, EventHeaderFactory headerFactory) {
        this.store = (EventStoreImpl)Preconditions.checkNotNull((Object)store);
        this.recorder = (EventRecorderImpl)Preconditions.checkNotNull((Object)recorder);
        this.anonymizer = (AnonymizerImpl)Preconditions.checkNotNull((Object)anonymizer);
        this.headerFactory = (EventHeaderFactory)((Object)Preconditions.checkNotNull((Object)((Object)headerFactory)));
    }

    protected CollectionCapabilityConfiguration createConfig(Map<String, String> properties) throws Exception {
        return new CollectionCapabilityConfiguration(properties);
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }

    protected void onActivate(CollectionCapabilityConfiguration config) throws Exception {
        this.store.start();
        this.anonymizer.setSalt(config.getSaltBytes());
        this.headerFactory.setNode(config.getHostId());
        this.recorder.setEnabled(true);
        this.log.info("Collection enabled");
    }

    protected void onPassivate(CollectionCapabilityConfiguration config) throws Exception {
        this.recorder.setEnabled(false);
        this.store.stop();
        this.log.info("Collection disabled");
    }

    protected String renderDescription() throws Exception {
        if (!this.context().isActive()) {
            return messages.disabledDescription();
        }
        return messages.description(this.store.approximateSize());
    }

    protected String renderStatus() throws Exception {
        if (!this.context().isActive()) {
            return null;
        }
        return this.render("analytics.collection-status.vm", new TemplateParameters().set("store", (Object)this.store).get());
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Events: %s")
        public String description(long var1);

        @MessageBundle.DefaultMessage(value="Collection disabled")
        public String disabledDescription();
    }
}

