/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.internal.AutoSubmitCapabilityConfiguration;
import com.sonatype.nexus.analytics.internal.CollectionCapabilityDescriptor;
import com.sonatype.nexus.analytics.internal.SubmitTask;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.CapabilitySupport;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.schedules.CronSchedule;
import org.sonatype.scheduling.schedules.ManualRunSchedule;
import org.sonatype.scheduling.schedules.Schedule;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

@Named(value="analytics.autosubmit")
public class AutoSubmitCapability
extends CapabilitySupport<AutoSubmitCapabilityConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final NexusScheduler scheduler;
    private final Provider<SubmitTask> taskFactory;

    @Inject
    public AutoSubmitCapability(NexusScheduler scheduler, Provider<SubmitTask> taskFactory) {
        this.scheduler = (NexusScheduler)Preconditions.checkNotNull((Object)scheduler);
        this.taskFactory = (Provider)Preconditions.checkNotNull(taskFactory);
    }

    protected AutoSubmitCapabilityConfiguration createConfig(Map<String, String> properties) throws Exception {
        return new AutoSubmitCapabilityConfiguration(properties);
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.conditions().capabilities().capabilityOfTypeActive(CollectionCapabilityDescriptor.TYPE), this.conditions().capabilities().passivateCapabilityDuringUpdate()});
    }

    private ScheduledTask<?> getTask() throws Exception {
        ScheduledTask scheduled;
        List<ScheduledTask<?>> tasks = this.tasksForTypeId("SubmitTask");
        if (tasks.isEmpty()) {
            SubmitTask task = (SubmitTask)((Object)this.taskFactory.get());
            CronSchedule schedule = new CronSchedule("0 0 1 * * ?");
            scheduled = this.scheduler.schedule("Automatically submit analytics events", (NexusTask)task, (Schedule)schedule);
            this.log.debug("Created task: {}", (Object)scheduled);
        } else {
            Schedule schedule;
            if (tasks.size() != 1) {
                this.log.warn("More than 1 task found, additional tasks should be removed");
            }
            if ((schedule = (scheduled = tasks.get(0)).getSchedule()) instanceof ManualRunSchedule) {
                this.log.warn("Task schedule is set to manual");
            }
        }
        return scheduled;
    }

    private List<ScheduledTask<?>> tasksForTypeId(String typeId) {
        for (Map.Entry entry : this.scheduler.getActiveTasks().entrySet()) {
            if (!typeId.equals(entry.getKey())) continue;
            return (List)entry.getValue();
        }
        return Collections.emptyList();
    }

    protected void onActivate(AutoSubmitCapabilityConfiguration config) throws Exception {
        ScheduledTask<?> task = this.getTask();
        task.setEnabled(true);
        this.scheduler.updateSchedule(task);
        this.log.info("Automatic submission enabled");
    }

    protected void onPassivate(AutoSubmitCapabilityConfiguration config) throws Exception {
        ScheduledTask<?> task = this.getTask();
        task.setEnabled(false);
        this.scheduler.updateSchedule(task);
        this.log.info("Automatic submission disabled");
    }

    protected void onRemove(AutoSubmitCapabilityConfiguration config) throws Exception {
        for (ScheduledTask<?> task : this.tasksForTypeId("SubmitTask")) {
            task.cancel();
        }
    }

    protected String renderDescription() throws Exception {
        if (!this.context().isActive()) {
            return messages.disabledDescription();
        }
        return messages.description();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Submission enabled")
        public String description();

        @MessageBundle.DefaultMessage(value="Submission disabled")
        public String disabledDescription();
    }
}

