/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sonatype.nexus.analytics.Anonymizer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.util.Tokens;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.crypto.CryptoHelper;

@Named
@Singleton
public class AnonymizerImpl
extends ComponentSupport
implements Anonymizer {
    private final CryptoHelper crypto;
    private byte[] salt;

    @Inject
    public AnonymizerImpl(CryptoHelper crypto) {
        this.crypto = (CryptoHelper)Preconditions.checkNotNull((Object)crypto);
    }

    public void setSalt(byte[] salt) {
        Preconditions.checkNotNull((Object)salt);
        Preconditions.checkArgument((salt.length != 0 ? 1 : 0) != 0);
        this.salt = salt;
    }

    @Override
    public byte[] anonymize(byte[] data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument((data.length != 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.salt != null ? 1 : 0) != 0, (Object)"Missing salt");
        MessageDigest digest = this.createDigest();
        digest.update(this.salt);
        digest.update(data);
        return digest.digest();
    }

    @Override
    public String anonymize(String data) {
        Preconditions.checkNotNull((Object)data);
        byte[] bytes = this.anonymize(data.getBytes(Charsets.UTF_8));
        return Tokens.encodeHexString((byte[])bytes);
    }

    private MessageDigest createDigest() {
        try {
            return this.crypto.createDigest("sha1");
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

