/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import com.sonatype.nexus.analytics.internal.RestRequestCollector;
import io.kazuki.v0.store.easy.EasyPartitionedJournalStoreModule;
import io.kazuki.v0.store.jdbi.JdbiDataSourceConfiguration;
import io.kazuki.v0.store.keyvalue.KeyValueStoreConfiguration;
import io.kazuki.v0.store.lifecycle.LifecycleModule;
import io.kazuki.v0.store.sequence.SequenceServiceConfiguration;
import java.io.File;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.web.internal.SecurityFilter;

@Named
public class AnalyticsModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new LifecycleModule("nexusanalytics", new String[0]));
        this.bind(JdbiDataSourceConfiguration.class).annotatedWith((Annotation)Names.named((String)"nexusanalytics")).toProvider(JdbiConfigurationProvider.class).in(Scopes.SINGLETON);
        EasyPartitionedJournalStoreModule journalModule = new EasyPartitionedJournalStoreModule("nexusanalytics", null);
        journalModule.withSequenceConfig(this.getSequenceServiceConfiguration());
        journalModule.withKeyValueStoreConfig(this.getKeyValueStoreConfiguration());
        this.install((Module)journalModule);
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.filter("/*", new String[0]).through(SecurityFilter.class);
                this.filter("/service/local/*", new String[0]).through(RestRequestCollector.class);
                this.filter("/service/siesta/*", new String[0]).through(RestRequestCollector.class);
                this.filter("/internal/*", new String[0]).through(RestRequestCollector.class);
            }
        });
    }

    private SequenceServiceConfiguration getSequenceServiceConfiguration() {
        SequenceServiceConfiguration.Builder builder = new SequenceServiceConfiguration.Builder();
        builder.withDbType("h2");
        builder.withGroupName("nexus");
        builder.withStoreName("analytics");
        builder.withStrictTypeCreation(true);
        return builder.build();
    }

    private KeyValueStoreConfiguration getKeyValueStoreConfiguration() {
        KeyValueStoreConfiguration.Builder builder = new KeyValueStoreConfiguration.Builder();
        builder.withDbType("h2");
        builder.withGroupName("nexus");
        builder.withStoreName("analytics");
        builder.withPartitionName("default");
        builder.withPartitionSize(Long.valueOf(100000L));
        builder.withStrictTypeCreation(true);
        builder.withDataType("event_data");
        return builder.build();
    }

    private static class JdbiConfigurationProvider
    implements Provider<JdbiDataSourceConfiguration> {
        private final ApplicationDirectories directories;

        @Inject
        public JdbiConfigurationProvider(ApplicationDirectories directories) {
            this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        }

        public JdbiDataSourceConfiguration get() {
            JdbiDataSourceConfiguration.Builder builder = new JdbiDataSourceConfiguration.Builder();
            builder.withJdbcDriver("org.h2.Driver");
            File dir = this.directories.getWorkDirectory("db/analytics");
            File file = new File(dir, dir.getName());
            builder.withJdbcUrl("jdbc:h2:" + file.getAbsolutePath());
            builder.withJdbcUser("root");
            builder.withJdbcPassword("not_really_used");
            builder.withPoolMinConnections(25);
            builder.withPoolMaxConnections(25);
            return builder.build();
        }
    }
}

