/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.analytics.internal.AutoSubmitCapabilityDescriptor;
import com.sonatype.nexus.analytics.internal.CollectionCapabilityDescriptor;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.support.CapabilityBooterSupport;
import org.sonatype.nexus.util.Tokens;
import org.sonatype.sisu.goodies.crypto.RandomBytesGenerator;

@Named
@EagerSingleton
public class AnalyticsCapabilitiesBooter
extends CapabilityBooterSupport {
    private final RandomBytesGenerator randomBytesGenerator;

    @Inject
    public AnalyticsCapabilitiesBooter(RandomBytesGenerator randomBytesGenerator) {
        this.randomBytesGenerator = (RandomBytesGenerator)Preconditions.checkNotNull((Object)randomBytesGenerator);
    }

    protected void boot(CapabilityRegistry registry) throws Exception {
        this.maybeAddCapability(registry, CollectionCapabilityDescriptor.TYPE, false, null, (Map)ImmutableMap.of((Object)"hostId", (Object)this.randomHostId(), (Object)"salt", (Object)this.randomSalt()));
        this.maybeAddCapability(registry, AutoSubmitCapabilityDescriptor.TYPE, false, null, null);
    }

    private String randomHostId() {
        return UUID.randomUUID().toString();
    }

    private String randomSalt() {
        return Tokens.encodeBase64String((byte[])this.randomBytesGenerator.generate(33));
    }
}

