/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

class RollingCounter {
    private final AtomicLong value = new AtomicLong(-1L);
    private final long max;

    RollingCounter(long max) {
        Preconditions.checkArgument((max > 0L ? 1 : 0) != 0);
        this.max = max + 1L;
    }

    public long next() {
        long next;
        long current;
        while (!this.value.compareAndSet(current = this.value.get(), next = (current + 1L) % this.max)) {
        }
        return next;
    }
}

