/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.analytics;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.analytics.EventData;
import com.sonatype.nexus.analytics.RollingCounter;
import javax.annotation.Nullable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class EventDataBuilder {
    private static final RollingCounter counter = new RollingCounter(999999999999999L);
    private final EventData data = new EventData();
    private final long started;

    public EventDataBuilder(String type) {
        this.data.setType(type);
        this.data.setTimestamp(System.currentTimeMillis());
        this.data.setSequence(counter.next());
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Session session;
            Object principal = subject.getPrincipal();
            if (principal != null) {
                this.data.setUserId(principal.toString());
            }
            if ((session = subject.getSession(false)) != null) {
                this.data.setSessionId(session.getId().toString());
            }
        }
        this.started = System.nanoTime();
    }

    public EventDataBuilder set(String name, @Nullable Object value) {
        Preconditions.checkNotNull((Object)name);
        if (value == null) {
            this.data.getAttributes().put(name, null);
        } else {
            this.data.getAttributes().put(name, String.valueOf(value));
        }
        return this;
    }

    public EventData build() {
        this.data.setDuration(System.nanoTime() - this.started);
        return this.data;
    }
}

