/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.proxy;

import com.google.common.base.Throwables;
import java.io.IOException;
import org.sonatype.nexus.plugins.ruby.NexusStorage;
import org.sonatype.nexus.plugins.ruby.proxy.ProxyRubyRepository;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.ruby.BundlerApiFile;
import org.sonatype.nexus.ruby.DependencyFile;
import org.sonatype.nexus.ruby.layout.ProxyStorage;

public class ProxyNexusStorage
extends NexusStorage
implements ProxyStorage {
    private final ProxyRubyRepository repository;

    public ProxyNexusStorage(ProxyRubyRepository repository) {
        super(repository);
        this.repository = repository;
    }

    public void retrieve(BundlerApiFile file) {
        try {
            this.log.debug("retrieve :: {}", (Object)file);
            file.set((Object)this.repository.retrieveDirectItem(new ResourceStoreRequest(file.storagePath(), false, true)));
        }
        catch (IOException | IllegalOperationException | ItemNotFoundException e) {
            file.setException((Exception)e);
        }
    }

    public boolean isExpired(DependencyFile file) {
        boolean expired = true;
        try {
            ResourceStoreRequest request = new ResourceStoreRequest(file.storagePath(), true, false);
            if (this.repository.getLocalStorage().containsItem((Repository)this.repository, request)) {
                AbstractStorageItem item = this.repository.getLocalStorage().retrieveItem((Repository)this.repository, request);
                long maxAge = this.repository.getMetadataMaxAge();
                expired = maxAge > -1L ? item.isExpired() || System.currentTimeMillis() - item.getRemoteChecked() > maxAge * 60L * 1000L : false;
            }
        }
        catch (ItemNotFoundException request) {
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.log.debug("isExpired={} :: {}", (Object)expired, (Object)file);
        return expired;
    }
}

