/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.proxy;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.plugins.ruby.NexusRubygemsFacade;
import org.sonatype.nexus.plugins.ruby.PurgeBrokenFilesRubygemsWalkerProcessor;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.plugins.ruby.proxy.DefaultProxyRubyRepositoryConfiguration;
import org.sonatype.nexus.plugins.ruby.proxy.ProxyNexusStorage;
import org.sonatype.nexus.plugins.ruby.proxy.ProxyRubyRepository;
import org.sonatype.nexus.plugins.ruby.proxy.ProxyRubyRepositoryConfigurator;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.ruby.FileType;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.nexus.ruby.SpecsIndexType;
import org.sonatype.nexus.ruby.cuba.RubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.ProxiedRubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.ProxyStorage;

@Named(value="rubygems-proxy")
public class DefaultProxyRubyRepository
extends AbstractProxyRepository
implements ProxyRubyRepository,
Repository {
    public static final String ID = "rubygems-proxy";
    private final ContentClass contentClass;
    private final ProxyRubyRepositoryConfigurator configurator;
    private final RubygemsGateway gateway;
    private final RepositoryKind repositoryKind;
    private NexusRubygemsFacade facade;
    private static Pattern BUNDLER_API_REQUEST = Pattern.compile(".*[?]gems=.*");

    @Inject
    public DefaultProxyRubyRepository(@Named(value="rubygems") ContentClass contentClass, ProxyRubyRepositoryConfigurator configurator, RubygemsGateway gateway) {
        this.contentClass = contentClass;
        this.configurator = configurator;
        this.gateway = gateway;
        this.repositoryKind = new DefaultRepositoryKind(ProxyRubyRepository.class, Arrays.asList(RubyRepository.class));
        this.facade = new NexusRubygemsFacade((RubygemsFileSystem)new ProxiedRubygemsFileSystem(gateway, (ProxyStorage)new ProxyNexusStorage(this)));
    }

    protected Configurator<Repository, CRepositoryCoreConfiguration> getConfigurator() {
        return this.configurator;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<DefaultProxyRubyRepositoryConfiguration>(){

            public DefaultProxyRubyRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new DefaultProxyRubyRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    protected DefaultProxyRubyRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (DefaultProxyRubyRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    protected boolean isOld(StorageItem item) {
        if (item.getName().endsWith("specs.4.8")) {
            return false;
        }
        if (item.getName().endsWith(".gz")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} needs remote update {} ", (Object)item, (Object)this.isOld(this.getMetadataMaxAge(), item));
            }
            return this.isOld(this.getMetadataMaxAge(), item);
        }
        if (item.getName().endsWith(".ruby")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} needs remote update {}", (Object)item, (Object)this.isOld(this.getMetadataMaxAge(), item));
            }
            if (this.isOld(this.getMetadataMaxAge(), item)) {
                try {
                    super.deleteItem(false, item.getResourceStoreRequest());
                }
                catch (IOException | IllegalOperationException | ItemNotFoundException | UnsupportedStorageOperationException e) {
                    this.log.warn("could not delete volatile file: {}", (Object)item, (Object)e);
                }
                return true;
            }
            return false;
        }
        return this.isOld(this.getArtifactMaxAge(), item);
    }

    @Override
    public int getArtifactMaxAge() {
        return this.getExternalConfiguration(false).getArtifactMaxAge();
    }

    @Override
    public void setArtifactMaxAge(int maxAge) {
        this.getExternalConfiguration(true).setArtifactMaxAge(maxAge);
    }

    @Override
    public int getMetadataMaxAge() {
        return this.getExternalConfiguration(false).getMetadataMaxAge();
    }

    @Override
    public void setMetadataMaxAge(int metadataMaxAge) {
        this.getExternalConfiguration(true).setMetadataMaxAge(metadataMaxAge);
    }

    public AbstractStorageItem doCacheItem(AbstractStorageItem item) throws LocalStorageException {
        if (BUNDLER_API_REQUEST.matcher(item.getRepositoryItemUid().getPath()).matches()) {
            return item;
        }
        item.getResourceStoreRequest().setRequestPath(item.getRepositoryItemUid().getPath());
        return super.doCacheItem(item);
    }

    protected AbstractStorageItem doRetrieveRemoteItem(ResourceStoreRequest request) throws ItemNotFoundException, StorageException {
        RubygemsFile file = this.facade.file(request.getRequestPath());
        request.setRequestPath(file.remotePath());
        return super.doRetrieveRemoteItem(request);
    }

    public RepositoryItemUid createUid(String path) {
        RubygemsFile file = this.facade.file(path);
        if (file.type() == FileType.NOT_FOUND) {
            return super.createUid(path);
        }
        return super.createUid(file.storagePath());
    }

    public void moveItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException {
        throw new UnsupportedStorageOperationException(from.getRequestPath());
    }

    @Override
    public StorageItem retrieveDirectItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, IOException {
        return super.retrieveItem(false, request);
    }

    public StorageItem retrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        if (request.getRequestPath().startsWith("/.nexus")) {
            return super.retrieveItem(request);
        }
        return this.facade.handleRetrieve(this, request, this.facade.get(request));
    }

    public StorageItem retrieveItem(boolean fromTask, ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (!fromTask && request.getRequestPath().contains("?gems=") && !request.getRequestPath().startsWith("/.nexus")) {
            return this.facade.handleRetrieve(this, request, this.facade.get(request));
        }
        return super.retrieveItem(fromTask, request);
    }

    @Override
    public void syncMetadata() throws IllegalOperationException, ItemNotFoundException, IOException {
        this.log.debug("sync rubygems specs.4.8.gz, latest_specs.4.8.gz, prereleased_specs.4.8.gz");
        for (SpecsIndexType type : SpecsIndexType.values()) {
            ResourceStoreRequest request = new ResourceStoreRequest(type.filepathGzipped());
            request.setRequestRemoteOnly(true);
            this.retrieveItem(true, request);
        }
        this.purgeBrokenMetadataFiles();
    }

    @Override
    public void purgeBrokenMetadataFiles() throws IllegalOperationException, ItemNotFoundException, IOException {
        block2: {
            this.log.info("Recreating Rubygems index in hosted repository {}", (Object)this);
            PurgeBrokenFilesRubygemsWalkerProcessor wp = new PurgeBrokenFilesRubygemsWalkerProcessor(this.log, this.gateway);
            DefaultWalkerContext ctx = new DefaultWalkerContext((Repository)this, new ResourceStoreRequest("/"));
            ctx.getProcessors().add(wp);
            try {
                this.getWalker().walk((WalkerContext)ctx);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block2;
                throw e;
            }
        }
    }
}

