/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.hosted;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jruby.runtime.builtin.IRubyObject;
import org.slf4j.Logger;
import org.sonatype.nexus.plugins.ruby.NexusRubygemsFacade;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.ruby.GemFile;
import org.sonatype.nexus.ruby.GemspecHelper;
import org.sonatype.nexus.ruby.IOUtil;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.nexus.ruby.SpecsHelper;
import org.sonatype.nexus.ruby.SpecsIndexType;

public class RecreateIndexRubygemsWalkerProcessor
extends AbstractWalkerProcessor {
    private RubyRepository repository;
    private final Logger logger;
    private final RubygemsGateway rubygems;
    private final SpecsHelper specs;
    private final ByteArrayInputStream[] index = new ByteArrayInputStream[SpecsIndexType.values().length];
    private final NexusRubygemsFacade facade;

    public RecreateIndexRubygemsWalkerProcessor(Logger logger, RubygemsGateway rubygems, NexusRubygemsFacade facade) {
        this.logger = logger;
        this.rubygems = rubygems;
        this.specs = rubygems.newSpecsHelper();
        for (SpecsIndexType type : SpecsIndexType.values()) {
            this.index[type.ordinal()] = this.specs.createEmptySpecs();
        }
        this.facade = facade;
    }

    public void beforeWalk(WalkerContext context) throws Exception {
        this.repository = context.getRepository() instanceof RubyRepository ? (RubyRepository)context.getRepository() : null;
        this.setActive(this.repository != null);
    }

    public void processItem(WalkerContext context, StorageItem item) {
        block31: {
            if (!(item instanceof StorageFileItem)) break block31;
            RubygemsFile file = this.facade.file(item.getPath());
            try {
                switch (file.type()) {
                    case DEPENDENCY: {
                        this.logger.debug("deleting :: {}", (Object)file.storagePath());
                        this.repository.deleteItem(true, new ResourceStoreRequest(item));
                        break;
                    }
                    case GEM: {
                        GemspecHelper gemspecHelper;
                        SpecsIndexType[] specsIndexTypeArray = null;
                        try (InputStream is = ((StorageFileItem)item).getInputStream();){
                            gemspecHelper = this.rubygems.newGemspecHelperFromGem(is);
                        }
                        catch (Throwable object) {
                            specsIndexTypeArray = object;
                            throw object;
                        }
                        this.logger.debug("recreating :: {}", (Object)gemspecHelper.filename());
                        is = gemspecHelper.getRzInputStream();
                        specsIndexTypeArray = null;
                        try {
                            this.repository.storeItem(false, this.newStorageItem((RubygemsFile)((GemFile)file).gemspec(), is));
                        }
                        catch (Throwable throwable) {
                            specsIndexTypeArray = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is != null) {
                                if (specsIndexTypeArray != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {
                                        specsIndexTypeArray.addSuppressed(throwable);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                        IRubyObject spec = gemspecHelper.gemspec();
                        for (SpecsIndexType type : SpecsIndexType.values()) {
                            this.logger.debug("adding :: {} to {}", (Object)spec, (Object)type);
                            this.index[type.ordinal()].reset();
                            ByteArrayInputStream result = this.specs.addSpec(spec, (InputStream)this.index[type.ordinal()], type);
                            if (result == null || result.available() <= 0) continue;
                            this.index[type.ordinal()] = result;
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Error occurred while processing item '" + item.getPath() + "'.", (Throwable)e);
            }
        }
    }

    public void storeIndex() {
        for (SpecsIndexType type : SpecsIndexType.values()) {
            try {
                this.index[type.ordinal()].reset();
                this.repository.storeItem(false, this.newStorageItem(this.facade.file(type.filepathGzipped()), IOUtil.toGzipped((InputStream)this.index[type.ordinal()])));
            }
            catch (Exception e) {
                this.logger.warn("Error occurred while processing item '" + type.filepathGzipped() + "'.", (Throwable)e);
            }
        }
    }

    public StorageItem newStorageItem(RubygemsFile file, InputStream is) {
        ResourceStoreRequest request = new ResourceStoreRequest(file.storagePath());
        PreparedContentLocator contentLocator = new PreparedContentLocator(is, file.type().mime(), -1L);
        return new DefaultStorageFileItem((Repository)this.repository, request, true, true, (ContentLocator)contentLocator);
    }
}

