/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.hosted;

import java.util.List;
import javax.inject.Named;
import org.sonatype.nexus.plugins.ruby.hosted.HostedRubyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

@Named(value="RebuildRubygemsMetadataTask")
public class RebuildRubygemsMetadataTask
extends AbstractNexusRepositoriesTask<Object> {
    public static final String ACTION = "REBUILDRUBYGEMSMETADATA";

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }

    public Object doRun() throws Exception {
        if (this.getRepositoryId() != null) {
            Repository repository = this.getRepositoryRegistry().getRepository(this.getRepositoryId());
            if (repository.getRepositoryKind().isFacetAvailable(HostedRubyRepository.class)) {
                HostedRubyRepository rubyRepository = (HostedRubyRepository)repository.adaptToFacet(HostedRubyRepository.class);
                rubyRepository.recreateMetadata();
            } else {
                this.getLogger().info("Repository {} is not a hosted Rubygems repository. Will not rebuild metadata, but the task seems wrongly configured!", (Object)repository);
            }
        } else {
            List reposes = this.getRepositoryRegistry().getRepositoriesWithFacet(HostedRubyRepository.class);
            for (HostedRubyRepository repo : reposes) {
                repo.recreateMetadata();
            }
        }
        return null;
    }

    protected String getAction() {
        return ACTION;
    }

    protected String getMessage() {
        if (this.getRepositoryId() != null) {
            return "Rebuilding gemspecs and specs-index of repository " + this.getRepositoryName();
        }
        return "Rebuilding gemspecs and specs-index of all registered repositories";
    }
}

