/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.hosted;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.plugins.ruby.NexusRubygemsFacade;
import org.sonatype.nexus.plugins.ruby.NexusStorage;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.plugins.ruby.hosted.DefaultHostedRubyRepositoryConfiguration;
import org.sonatype.nexus.plugins.ruby.hosted.HostedRubyRepository;
import org.sonatype.nexus.plugins.ruby.hosted.HostedRubyRepositoryConfigurator;
import org.sonatype.nexus.plugins.ruby.hosted.RecreateIndexRubygemsWalkerProcessor;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.nexus.ruby.cuba.RubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.HostedRubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.Storage;

@Named(value="rubygems-hosted")
public class DefaultHostedRubyRepository
extends AbstractRepository
implements HostedRubyRepository,
Repository {
    public static final String ID = "rubygems-hosted";
    private final ContentClass contentClass;
    private final HostedRubyRepositoryConfigurator configurator;
    private final RubygemsGateway gateway;
    private final RepositoryKind repositoryKind;
    private final NexusRubygemsFacade facade;

    @Inject
    public DefaultHostedRubyRepository(@Named(value="rubygems") ContentClass contentClass, HostedRubyRepositoryConfigurator configurator, RubygemsGateway gateway) {
        this.contentClass = contentClass;
        this.configurator = configurator;
        this.repositoryKind = new DefaultRepositoryKind(HostedRubyRepository.class, Arrays.asList(RubyRepository.class));
        this.gateway = gateway;
        this.facade = new NexusRubygemsFacade((RubygemsFileSystem)new HostedRubygemsFileSystem(gateway, (Storage)new NexusStorage(this)));
    }

    protected Configurator<Repository, CRepositoryCoreConfiguration> getConfigurator() {
        return this.configurator;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<DefaultHostedRubyRepositoryConfiguration>(){

            public DefaultHostedRubyRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new DefaultHostedRubyRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    protected DefaultHostedRubyRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (DefaultHostedRubyRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    public void storeItem(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        RubygemsFile file = this.facade.file(request.getRequestPath());
        if (file == null) {
            throw new UnsupportedStorageOperationException("only gem-files can be stored");
        }
        request.setRequestPath(file.storagePath());
        try {
            this.checkConditions(request, this.getResultingActionOnWrite(request));
        }
        catch (ItemNotFoundException e) {
            throw new AccessDeniedException(request, e.getMessage());
        }
        this.facade.handleMutation(this, this.facade.post(is, file));
    }

    public void deleteItem(ResourceStoreRequest request) throws StorageException, UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException {
        this.facade.handleMutation(this, this.facade.delete(request.getRequestPath()));
    }

    public void moveItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException {
        throw new UnsupportedStorageOperationException(from.getRequestPath());
    }

    @Override
    public StorageItem retrieveDirectItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, IOException {
        return super.retrieveItem(false, request);
    }

    public StorageItem retrieveItem(boolean fromTask, ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (fromTask && request.getRequestPath().startsWith("/.nexus")) {
            return super.retrieveItem(true, request);
        }
        return this.facade.handleRetrieve(this, request, this.facade.get(request));
    }

    @Override
    public void recreateMetadata() throws LocalStorageException, ItemNotFoundException {
        RecreateIndexRubygemsWalkerProcessor wp;
        block2: {
            this.log.info("Recreating Rubygems index in hosted repository {}", (Object)this);
            wp = new RecreateIndexRubygemsWalkerProcessor(this.log, this.gateway, this.facade);
            DefaultWalkerContext ctx = new DefaultWalkerContext((Repository)this, new ResourceStoreRequest("/"));
            ctx.getProcessors().add(wp);
            try {
                this.getWalker().walk((WalkerContext)ctx);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block2;
                throw e;
            }
        }
        wp.storeIndex();
    }
}

