/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.group;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.nexus.plugins.ruby.NexusStorage;
import org.sonatype.nexus.plugins.ruby.RubyGroupRepository;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.GroupItemNotFoundException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.ruby.BundlerApiFile;
import org.sonatype.nexus.ruby.DependencyFile;
import org.sonatype.nexus.ruby.DependencyHelper;
import org.sonatype.nexus.ruby.MergeSpecsHelper;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.nexus.ruby.SpecsIndexType;
import org.sonatype.nexus.ruby.SpecsIndexZippedFile;
import org.sonatype.nexus.ruby.layout.ProxyStorage;

public class GroupNexusStorage
extends NexusStorage
implements ProxyStorage {
    private final RubygemsGateway gateway;
    private final RubyGroupRepository repository;

    public GroupNexusStorage(RubyGroupRepository repository, RubygemsGateway gateway) {
        super(repository);
        this.repository = repository;
        this.gateway = gateway;
    }

    @Override
    public void retrieve(DependencyFile file) {
        this.doRetrieve((RubygemsFile)file);
    }

    @Override
    public void retrieve(SpecsIndexZippedFile file) {
        this.doRetrieve((RubygemsFile)file);
    }

    private void doRetrieve(RubygemsFile file) {
        try {
            this.log.debug("doRetrieve :: {}", (Object)file);
            file.set((Object)this.setup(file));
        }
        catch (ItemNotFoundException e) {
            this.log.debug("doRetrieve-NotFound :: {} :: {}", (Object)file, (Object)e.toString());
            file.markAsNotExists();
        }
        catch (Exception e) {
            this.log.debug("doRetrieve-Exception :: {} :: {}", (Object)file, (Object)e.toString());
            file.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageItem setup(RubygemsFile file) throws Exception {
        ResourceStoreRequest req = new ResourceStoreRequest(file.storagePath());
        RubyGroupRepository rubyGroupRepository = this.repository;
        synchronized (rubyGroupRepository) {
            List items = this.repository.doRetrieveItems(req);
            if (items.size() == 1) {
                return (StorageItem)items.get(0);
            }
            return this.store(file, items);
        }
    }

    private StorageItem store(RubygemsFile file, List<StorageItem> items) throws Exception {
        StorageFileItem localItem = null;
        try {
            localItem = (StorageFileItem)this.repository.getLocalStorage().retrieveItem((Repository)this.repository, new ResourceStoreRequest(file.storagePath()));
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        boolean outdated = true;
        if (localItem != null) {
            long modified = localItem.getModified();
            outdated = false;
            for (StorageItem item : items) {
                outdated = outdated || item.getModified() > modified;
            }
        }
        if (outdated) {
            switch (file.type()) {
                case DEPENDENCY: {
                    return this.mergeDependency((DependencyFile)file, items);
                }
                case SPECS_INDEX_ZIPPED: {
                    return this.mergeSpecsIndex((SpecsIndexZippedFile)file, items);
                }
            }
            throw new RuntimeException("BUG: should never reach here: " + file);
        }
        return localItem;
    }

    private StorageItem mergeSpecsIndex(SpecsIndexZippedFile file, List<StorageItem> items) throws Exception {
        this.log.debug("mergeSpecsIndex :: {} :: {}", (Object)file, items);
        MergeSpecsHelper specs = this.gateway.newMergeSpecsHelper();
        for (StorageItem item : items) {
            InputStream is = ((StorageFileItem)item).getInputStream();
            Throwable throwable = null;
            try {
                specs.add((InputStream)new GZIPInputStream(is));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        try (ByteArrayInputStream is = specs.getInputStream(file.specsType() == SpecsIndexType.LATEST);){
            StorageItem storageItem = this.storeSpecsIndex(file, is);
            return storageItem;
        }
    }

    private StorageItem storeSpecsIndex(SpecsIndexZippedFile file, InputStream content) throws Exception {
        ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(gzipped);){
            IOUtil.copy((InputStream)content, (OutputStream)out);
        }
        PreparedContentLocator cl = new PreparedContentLocator((InputStream)new ByteArrayInputStream(gzipped.toByteArray()), "application/x-gzip", (long)gzipped.size());
        DefaultStorageFileItem item = new DefaultStorageFileItem((Repository)this.repository, new ResourceStoreRequest(file.storagePath()), true, true, (ContentLocator)cl);
        this.repository.storeItem(false, (StorageItem)item);
        return item;
    }

    private StorageItem mergeDependency(DependencyFile file, List<StorageItem> dependencies) throws Exception {
        StorageItem item2;
        this.log.debug("mergeDependency :: {} :: {}", (Object)file, dependencies);
        DependencyHelper deps = this.gateway.newDependencyHelper();
        for (StorageItem item2 : dependencies) {
            InputStream is = ((StorageFileItem)item2).getInputStream();
            Throwable throwable = null;
            try {
                deps.add(is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        PreparedContentLocator cl = new PreparedContentLocator((InputStream)deps.getInputStream(true), file.type().mime(), -1L);
        item2 = new DefaultStorageFileItem((Repository)this.repository, new ResourceStoreRequest(file.storagePath()), true, true, (ContentLocator)cl);
        this.repository.storeItem(false, item2);
        return item2;
    }

    public void retrieve(BundlerApiFile file) {
        try {
            this.repository.doRetrieveItems(new ResourceStoreRequest(file.storagePath()));
            file.set(null);
        }
        catch (IOException | GroupItemNotFoundException e) {
            file.setException((Exception)e);
        }
    }

    public boolean isExpired(DependencyFile file) {
        return true;
    }
}

