/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby.group;

import java.io.IOException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.plugins.ruby.NexusRubygemsFacade;
import org.sonatype.nexus.plugins.ruby.RubyGroupRepository;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.plugins.ruby.group.DefaultRubyGroupRepositoryConfiguration;
import org.sonatype.nexus.plugins.ruby.group.GroupNexusStorage;
import org.sonatype.nexus.plugins.ruby.group.GroupRubyRepositoryConfigurator;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractGroupRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.nexus.ruby.cuba.RubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.ProxiedRubygemsFileSystem;
import org.sonatype.nexus.ruby.layout.ProxyStorage;

@Named(value="rubygems-group")
public class DefaultRubyGroupRepository
extends AbstractGroupRepository
implements RubyGroupRepository,
GroupRepository {
    public static final String ID = "rubygems-group";
    private final ContentClass contentClass;
    private final GroupRubyRepositoryConfigurator configurator;
    private final RepositoryKind repositoryKind;
    private final NexusRubygemsFacade facade;

    @Inject
    public DefaultRubyGroupRepository(@Named(value="rubygems") ContentClass contentClass, GroupRubyRepositoryConfigurator configurator, RubygemsGateway gateway) {
        this.contentClass = contentClass;
        this.configurator = configurator;
        this.facade = new NexusRubygemsFacade((RubygemsFileSystem)new ProxiedRubygemsFileSystem(gateway, (ProxyStorage)new GroupNexusStorage(this, gateway)));
        this.repositoryKind = new DefaultRepositoryKind(RubyGroupRepository.class, Arrays.asList(RubyRepository.class));
    }

    protected Configurator<Repository, CRepositoryCoreConfiguration> getConfigurator() {
        return this.configurator;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<DefaultRubyGroupRepositoryConfiguration>(){

            public DefaultRubyGroupRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new DefaultRubyGroupRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    protected DefaultRubyGroupRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (DefaultRubyGroupRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    public void deleteItem(ResourceStoreRequest request) throws UnsupportedStorageOperationException {
        throw new UnsupportedStorageOperationException(request.getRequestPath());
    }

    public void moveItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException {
        throw new UnsupportedStorageOperationException(from.getRequestPath());
    }

    public StorageItem retrieveItem(boolean fromTask, ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (fromTask && request.getRequestPath().startsWith("/.nexus")) {
            return super.retrieveItem(true, request);
        }
        return this.facade.handleRetrieve(this, request, this.facade.get(request));
    }

    @Override
    public StorageItem retrieveDirectItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, IOException {
        for (Repository repo : this.getMemberRepositories()) {
            try {
                return repo.retrieveItem(false, request);
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
        }
        throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (Repository)this, (String)"Could not find content for path %s in local storage of repository %s", (Object[])new Object[]{request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString((Repository)this)}));
    }
}

