/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby;

import java.io.InputStream;
import org.slf4j.Logger;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.ruby.RubygemsGateway;

public class PurgeBrokenFilesRubygemsWalkerProcessor
extends AbstractWalkerProcessor {
    private RubyRepository repository;
    private final Logger logger;
    private final RubygemsGateway rubygems;

    public PurgeBrokenFilesRubygemsWalkerProcessor(Logger logger, RubygemsGateway rubygems) {
        this.logger = logger;
        this.rubygems = rubygems;
    }

    public void beforeWalk(WalkerContext context) throws Exception {
        this.repository = context.getRepository() instanceof RubyRepository ? (RubyRepository)context.getRepository() : null;
        this.setActive(this.repository != null);
    }

    public void processItem(WalkerContext context, StorageItem item) {
        block32: {
            if (item instanceof StorageFileItem) {
                try {
                    if (item.getName().endsWith(".ruby")) {
                        try (InputStream is = ((StorageFileItem)item).getInputStream();){
                            this.rubygems.newDependencyHelper().add(is);
                            break block32;
                        }
                        catch (Exception e) {
                            this.repository.deleteItem(true, new ResourceStoreRequest(item));
                        }
                        break block32;
                    }
                    if (!item.getName().endsWith(".gemspec.rz")) break block32;
                    try (InputStream is = ((StorageFileItem)item).getInputStream();){
                        this.rubygems.newGemspecHelper(is);
                    }
                    catch (Exception e) {
                        this.repository.deleteItem(true, new ResourceStoreRequest(item));
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Error occurred while processing item '" + item.getPath() + "'.", (Throwable)e);
                }
            }
        }
    }
}

