/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.TreeSet;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.ruby.DependencyFile;
import org.sonatype.nexus.ruby.Directory;
import org.sonatype.nexus.ruby.IOUtil;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.SpecsIndexFile;
import org.sonatype.nexus.ruby.SpecsIndexZippedFile;
import org.sonatype.nexus.ruby.layout.Storage;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class NexusStorage
extends ComponentSupport
implements Storage {
    protected final RubyRepository repository;

    public NexusStorage(RubyRepository repository) {
        this.repository = repository;
    }

    public void retrieve(RubygemsFile file) {
        this.log.debug("retrieve :: {}", (Object)file);
        try {
            file.set((Object)this.repository.retrieveDirectItem(new ResourceStoreRequest(file.storagePath())));
        }
        catch (ItemNotFoundException e) {
            file.markAsNotExists();
        }
        catch (IOException | IllegalOperationException e) {
            file.setException((Exception)e);
        }
    }

    public void retrieve(DependencyFile file) {
        this.retrieve((RubygemsFile)file);
    }

    public void retrieve(SpecsIndexZippedFile file) {
        this.retrieve((RubygemsFile)file);
    }

    public void retrieve(SpecsIndexFile specs) {
        this.log.debug("retrieve :: {}", (Object)specs);
        SpecsIndexZippedFile source = specs.zippedSpecsIndexFile();
        try {
            StorageFileItem item = (StorageFileItem)this.repository.retrieveDirectItem(new ResourceStoreRequest(source.storagePath()));
            DefaultStorageFileItem unzippedItem = new DefaultStorageFileItem((Repository)this.repository, new ResourceStoreRequest(specs.storagePath()), true, false, this.gunzipContentLocator(item));
            unzippedItem.setModified(item.getModified());
            specs.set((Object)unzippedItem);
        }
        catch (ItemNotFoundException e) {
            specs.markAsNotExists();
        }
        catch (IOException | IllegalOperationException e) {
            specs.setException((Exception)e);
        }
    }

    private ContentLocator gunzipContentLocator(StorageFileItem item) throws IOException {
        try (InputStream in = item.getInputStream();){
            ByteArrayInputStream gzipped = IOUtil.toGunzipped((InputStream)in);
            PreparedContentLocator preparedContentLocator = new PreparedContentLocator((InputStream)gzipped, "application/x-marshal-ruby", (long)gzipped.available());
            return preparedContentLocator;
        }
    }

    public InputStream getInputStream(RubygemsFile file) throws IOException {
        if (file.get() == null) {
            this.retrieve(file);
        }
        return ((StorageFileItem)file.get()).getInputStream();
    }

    public long getModified(RubygemsFile file) {
        return ((StorageItem)file.get()).getModified();
    }

    public void create(InputStream is, RubygemsFile file) {
        this.update(is, file);
    }

    public void update(InputStream is, RubygemsFile file) {
        this.log.debug("update :: {}", (Object)file);
        ResourceStoreRequest request = new ResourceStoreRequest(file.storagePath());
        PreparedContentLocator contentLocator = new PreparedContentLocator(is, file.type().mime(), -1L);
        DefaultStorageFileItem fileItem = new DefaultStorageFileItem((Repository)this.repository, request, true, true, (ContentLocator)contentLocator);
        try {
            this.repository.storeItem(false, (StorageItem)fileItem);
            file.set((Object)fileItem);
        }
        catch (IOException | IllegalOperationException | UnsupportedStorageOperationException e) {
            file.setException((Exception)e);
        }
    }

    public void delete(RubygemsFile file) {
        this.log.debug("delete :: {}", (Object)file);
        ResourceStoreRequest request = new ResourceStoreRequest(file.storagePath());
        try {
            this.repository.deleteItem(false, request);
        }
        catch (IOException | IllegalOperationException | UnsupportedStorageOperationException e) {
            file.setException((Exception)e);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void memory(ByteArrayInputStream data, RubygemsFile file) {
        this.memory(data, file, -1L);
    }

    public void memory(String data, RubygemsFile file) {
        this.memory(new ByteArrayInputStream(data.getBytes()), file, data.getBytes().length);
    }

    private void memory(InputStream data, RubygemsFile file, long length) {
        PreparedContentLocator cl = new PreparedContentLocator(data, file.type().mime(), length);
        file.set((Object)new DefaultStorageFileItem((Repository)this.repository, new ResourceStoreRequest(file.storagePath()), true, false, (ContentLocator)cl));
    }

    public String[] listDirectory(Directory dir) {
        TreeSet<String> result = new TreeSet<String>(Arrays.asList(dir.getItems()));
        try {
            StorageItem list = this.repository.retrieveDirectItem(new ResourceStoreRequest(dir.storagePath()));
            if (list instanceof StorageCollectionItem) {
                for (StorageItem item : ((StorageCollectionItem)list).list()) {
                    result.add(item.getName());
                }
            }
        }
        catch (ItemNotFoundException list) {
        }
        catch (IOException | AccessDeniedException | IllegalOperationException | NoSuchResourceStoreException e) {
            dir.setException((Exception)e);
        }
        return result.toArray(new String[result.size()]);
    }
}

