/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jruby.embed.ScriptingContainer;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.ruby.DefaultRubygemsGateway;
import org.sonatype.nexus.ruby.RubygemsGateway;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class NexusRubygemsGatewayProvider
extends ComponentSupport
implements Provider<RubygemsGateway>,
EventSubscriber {
    private final Provider<ScriptingContainer> scriptingContainerProvider;
    private RubygemsGateway rubygemsGateway;

    @Inject
    public NexusRubygemsGatewayProvider(Provider<ScriptingContainer> scriptingContainerProvider) {
        this.scriptingContainerProvider = (Provider)Preconditions.checkNotNull(scriptingContainerProvider);
    }

    public synchronized RubygemsGateway get() {
        if (this.rubygemsGateway == null) {
            this.log.info("Creating JRuby RubygemsGateway");
            this.rubygemsGateway = new DefaultRubygemsGateway((ScriptingContainer)this.scriptingContainerProvider.get());
        }
        return this.rubygemsGateway;
    }

    @Subscribe
    public void on(NexusStoppedEvent event) {
        if (this.rubygemsGateway != null) {
            this.log.debug("Stopping JRuby RubygemsGateway");
            this.rubygemsGateway.terminate();
        }
    }
}

