/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.ruby;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import org.sonatype.nexus.plugins.ruby.RubyRepository;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.RemoteAccessException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.DefaultStorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.ruby.Directory;
import org.sonatype.nexus.ruby.FileType;
import org.sonatype.nexus.ruby.RubygemsFile;
import org.sonatype.nexus.ruby.cuba.RubygemsFileSystem;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public class NexusRubygemsFacade
extends ComponentSupport {
    private final RubygemsFileSystem filesystem;

    public NexusRubygemsFacade(RubygemsFileSystem filesystem) {
        this.filesystem = filesystem;
    }

    public RubygemsFile get(ResourceStoreRequest request) {
        String[] pathAndQuery = this.extractGemsQuery(request);
        this.log.debug("get :: {} :: query={}", (Object)request.getRequestPath(), (Object)pathAndQuery);
        return this.filesystem.get(pathAndQuery[0], pathAndQuery[1]);
    }

    private String[] extractGemsQuery(ResourceStoreRequest request) {
        if (request.getRequestPath().contains("?gems=")) {
            int index = request.getRequestPath().indexOf(63);
            return new String[]{request.getRequestPath().substring(0, index), request.getRequestPath().substring(index + 1)};
        }
        String query = "";
        if (request.getRequestUrl() != null && request.getRequestUrl().contains("?gems=")) {
            query = request.getRequestUrl().substring(request.getRequestUrl().indexOf(63) + 1);
        }
        return new String[]{request.getRequestPath(), query};
    }

    public RubygemsFile file(ResourceStoreRequest request) {
        String[] pathAndQuery = this.extractGemsQuery(request);
        this.log.debug("file :: {} :: query={}", (Object)request.getRequestPath(), (Object)pathAndQuery);
        return this.filesystem.file(pathAndQuery[0], pathAndQuery[1]);
    }

    public RubygemsFile file(String path) {
        return this.filesystem.file(path);
    }

    public RubygemsFile post(InputStream is, String path) {
        return this.filesystem.post(is, path);
    }

    public RubygemsFile post(InputStream is, RubygemsFile file) {
        this.filesystem.post(is, file);
        return file;
    }

    public RubygemsFile delete(String original) {
        return this.filesystem.delete(original);
    }

    public StorageItem handleCommon(RubyRepository repository, RubygemsFile file) throws IllegalOperationException, StorageException {
        this.log.debug("handleCommon :: {} :: {}", (Object)repository.getId(), (Object)file);
        switch (file.state()) {
            case ERROR: {
                Exception e = file.getException();
                this.log.debug("handleCommon :: ERROR", (Throwable)e);
                if (e instanceof IllegalOperationException) {
                    throw (IllegalOperationException)((Object)e);
                }
                if (e instanceof RemoteAccessException) {
                    throw (RemoteAccessException)e;
                }
                if (e instanceof StorageException) {
                    throw (StorageException)e;
                }
                if (e instanceof IOException) {
                    throw new StorageException((Throwable)e);
                }
                throw new RuntimeException(e);
            }
            case PAYLOAD: {
                return (StorageItem)file.get();
            }
            case FORBIDDEN: {
                throw new IllegalRequestException(new ResourceStoreRequest(file.remotePath()), "Repository with ID='" + repository.getId() + "' does not allow deleting '" + file.remotePath() + "'.");
            }
        }
        throw new RuntimeException("BUG: should not come here - " + file.state());
    }

    public StorageItem handleMutation(RubyRepository repository, RubygemsFile file) throws IllegalOperationException, StorageException, UnsupportedStorageOperationException {
        this.log.debug("handleMutation :: {} :: {}", (Object)repository.getId(), (Object)file);
        switch (file.state()) {
            case ERROR: {
                Exception e = file.getException();
                if (!(e instanceof UnsupportedStorageOperationException)) break;
                throw (UnsupportedStorageOperationException)((Object)e);
            }
        }
        return this.handleCommon(repository, file);
    }

    public StorageItem handleRetrieve(RubyRepository repository, ResourceStoreRequest req, RubygemsFile file) throws IllegalOperationException, StorageException, ItemNotFoundException {
        this.log.debug("handleRetrieve :: {} :: {}", (Object)repository.getId(), (Object)file);
        switch (file.state()) {
            case NO_PAYLOAD: {
                if (file.type() == FileType.DIRECTORY) {
                    req.setRequestPath(file.storagePath());
                    return new DirectoryStoreageItem(repository, req, (Directory)file);
                }
            }
            case NOT_EXISTS: {
                throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)new ResourceStoreRequest(file.remotePath()), (Repository)repository, (String)"Can not serve path %s for repository %s", (Object[])new Object[]{file.storagePath(), RepositoryStringUtils.getHumanizedNameString((Repository)repository)}));
            }
            case ERROR: {
                Exception e = file.getException();
                if (!(e instanceof ItemNotFoundException)) break;
                throw (ItemNotFoundException)((Object)e);
            }
        }
        return this.handleCommon(repository, file);
    }

    static class DirectoryStoreageItem
    extends DefaultStorageCollectionItem {
        private Directory dir;
        private RubyRepository repository;

        DirectoryStoreageItem(RubyRepository repository, ResourceStoreRequest req, Directory dir) {
            super((Repository)repository, req, true, false);
            this.dir = dir;
            this.repository = repository;
        }

        public Collection<StorageItem> list() throws AccessDeniedException, NoSuchResourceStoreException, IllegalOperationException, StorageException {
            LinkedList<StorageItem> result;
            try {
                result = super.list();
            }
            catch (ItemNotFoundException e) {
                result = new LinkedList<StorageItem>();
            }
            TreeSet<String> items = new TreeSet<String>(Arrays.asList(this.dir.getItems()));
            for (StorageItem i : result) {
                items.remove(i.getName());
                items.remove(i.getName() + "/");
            }
            for (String item : items) {
                if (item.endsWith("/")) continue;
                result.add((StorageItem)new DirectoryItemStorageItem(this.repository, this.dir.storagePath() + "/" + item));
            }
            return result;
        }
    }

    static class DirectoryItemStorageItem
    extends AbstractStorageItem {
        public DirectoryItemStorageItem(Repository repository, String path) {
            super(repository, new ResourceStoreRequest(path), true, false);
        }

        public boolean isVirtual() {
            return true;
        }
    }
}

