/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.inject.properties;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.sonatype.sisu.goodies.inject.properties.PropertiesSourceSupport;

public class SystemPropertyFilePropertiesSource
extends PropertiesSourceSupport {
    private final String propertyName;

    public SystemPropertyFilePropertiesSource(String propertyName) {
        this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName);
    }

    @Override
    protected Properties loadProperties() throws Exception {
        Properties props = new Properties();
        String location = System.getProperty(this.propertyName);
        if (location != null) {
            props.putAll((Map<?, ?>)this.loadProperties(new File(location)));
        } else {
            this.log.warn("Missing system property: {}", (Object)this.propertyName);
        }
        return props;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "propertyName='" + this.propertyName + '\'' + '}';
    }
}

