/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.inject.properties;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import org.sonatype.sisu.goodies.inject.properties.PropertiesSourceSupport;

public class ResourcePropertiesSource
extends PropertiesSourceSupport {
    private final Class owner;
    private final String resourceName;

    public ResourcePropertiesSource(@Nullable Class owner, String resourceName) {
        this.owner = owner == null ? this.getClass() : owner;
        this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName);
    }

    public ResourcePropertiesSource(String resourceName) {
        this(null, resourceName);
    }

    @Override
    protected Properties loadProperties() throws Exception {
        Properties props = new Properties();
        URL resource = this.owner.getResource(this.resourceName);
        if (resource != null) {
            props.putAll((Map<?, ?>)this.loadProperties(resource));
        } else {
            this.log.warn("Missing resource: {}", (Object)this.resourceName);
        }
        return props;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "owner=" + this.owner + ", resourceName='" + this.resourceName + '\'' + '}';
    }
}

