/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.inject.properties;

import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.io.Closer;
import org.sonatype.sisu.goodies.inject.properties.PropertiesSource;

public abstract class PropertiesSourceSupport
extends ComponentSupport
implements PropertiesSource {
    @Override
    public Properties properties() {
        try {
            return this.loadProperties();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected abstract Properties loadProperties() throws Exception;

    private boolean isBuffered(InputStream input) {
        return input instanceof BufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(InputStream input) throws Exception {
        Properties properties;
        Properties props = new Properties();
        if (!this.isBuffered(input)) {
            input = new BufferedInputStream(input);
        }
        try {
            props.load(input);
            properties = props;
        }
        catch (Throwable throwable) {
            Closer.close((Closeable[])new Closeable[]{input});
            throw throwable;
        }
        Closer.close((Closeable[])new Closeable[]{input});
        return properties;
    }

    private boolean isBuffered(Reader reader) {
        return reader instanceof BufferedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(Reader reader) throws Exception {
        Properties properties;
        Properties props = new Properties();
        if (!this.isBuffered(reader)) {
            reader = new BufferedReader(reader);
        }
        try {
            props.load(reader);
            properties = props;
        }
        catch (Throwable throwable) {
            Closer.close((Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        Closer.close((Closeable[])new Closeable[]{reader});
        return properties;
    }

    protected Properties loadProperties(File file) throws Exception {
        this.log.info("Loading properties from: {}", (Object)file);
        if (file.exists()) {
            return this.loadProperties(new FileReader(file));
        }
        this.log.warn("Missing properties file: {}", (Object)file);
        return new Properties();
    }

    protected Properties loadProperties(URL resource) throws Exception {
        this.log.debug("Loading properties from: {}", (Object)resource);
        return this.loadProperties(resource.openStream());
    }
}

