/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.inject.properties;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.sisu.wire.ParameterKeys;
import org.sonatype.sisu.goodies.common.Properties2;
import org.sonatype.sisu.goodies.inject.ModuleSupport;
import org.sonatype.sisu.goodies.inject.properties.PropertiesSource;

public class PropertiesModule
extends ModuleSupport {
    public static final String MASK = "****";
    private final List<PropertiesSource> sources = Lists.newArrayList();
    private final Set<String> mask = Sets.newHashSet();

    public List<PropertiesSource> getSources() {
        return this.sources;
    }

    public PropertiesModule source(PropertiesSource source) {
        Preconditions.checkNotNull((Object)source);
        this.getSources().add(source);
        return this;
    }

    public Set<String> getMask() {
        return this.mask;
    }

    public PropertiesModule mask(String propertyName) {
        Preconditions.checkNotNull((Object)propertyName);
        this.getMask().add(propertyName);
        return this;
    }

    @Override
    protected void configure() {
        Preconditions.checkState((this.getSources().size() != 0 ? 1 : 0) != 0, (Object)"At least one source is required");
        Properties props = new Properties();
        for (PropertiesSource source : this.getSources()) {
            this.log.debug("Loading properties from source: {}", (Object)source);
            props.putAll((Map<?, ?>)source.properties());
        }
        if (props.isEmpty()) {
            this.log.warn("No properties loaded");
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Properties:");
            for (String key : Properties2.sortKeys((Properties)props)) {
                Object value = props.get(key);
                if (this.mask.contains(key)) {
                    value = MASK;
                }
                this.log.debug("  {}={}", (Object)key, value);
            }
        }
        this.binder().bind(ParameterKeys.PROPERTIES).toInstance((Object)props);
    }
}

