/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.goodies.inject;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import org.jetbrains.annotations.NonNls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleSupport
extends AbstractModule {
    @NonNls
    protected final Logger log = (Logger)Preconditions.checkNotNull((Object)this.createLogger());

    protected Logger createLogger() {
        return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    protected void configure() {
    }

    protected <T, F> void bindFactory(Class<T> typeClass, Class<F> factoryClass) {
        this.install(new FactoryModuleBuilder().implement(typeClass, typeClass).build(factoryClass));
    }

    protected <T, F> void bindFactory(Class<T> typeClass, Class<? extends T> implClass, Class<F> factoryClass) {
        this.install(new FactoryModuleBuilder().implement(typeClass, implClass).build(factoryClass));
    }

    protected <T> Provider<T> defer(final T component) {
        Class<?> impl = component.getClass();
        final MembersInjector membersInjector = this.getMembersInjector(impl);
        this.bind(impl);
        return new Provider<T>(){

            public T get() {
                membersInjector.injectMembers(component);
                return component;
            }
        };
    }
}

