/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.task;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;
import org.sonatype.nexus.scheduling.AbstractNexusRepositoriesTask;

public abstract class NpmTaskSupport<T extends NpmRepository>
extends AbstractNexusRepositoriesTask<Void> {
    private final NexusConfiguration nexusConfiguration;

    @Inject
    public NpmTaskSupport(NexusConfiguration nexusConfiguration) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
    }

    protected final Void doRun() throws Exception {
        List<T> repositories = this.getAffectedRepositories();
        if (repositories.isEmpty()) {
            return null;
        }
        List<RepositoryWritePolicy> writePolicies = this.setWritePolicyReadOnly(repositories);
        try {
            this.doExecute(repositories);
        }
        finally {
            this.resetWritePolicy(repositories, writePolicies);
        }
        return null;
    }

    protected abstract List<T> getAffectedRepositories();

    protected abstract void doExecute(List<T> var1) throws Exception;

    protected List<RepositoryWritePolicy> setWritePolicyReadOnly(List<? extends NpmRepository> repositories) throws IOException {
        ArrayList result = Lists.newArrayList();
        for (NpmRepository npmRepository : repositories) {
            result.add(npmRepository.getWritePolicy());
            npmRepository.setWritePolicy(RepositoryWritePolicy.READ_ONLY);
        }
        this.nexusConfiguration.saveConfiguration();
        return result;
    }

    protected void resetWritePolicy(List<? extends NpmRepository> repositories, List<RepositoryWritePolicy> writePolicies) throws IOException {
        Preconditions.checkArgument((repositories.size() == writePolicies.size() ? 1 : 0) != 0, (Object)"inconsistent original write policies");
        for (int i = 0; i < repositories.size(); ++i) {
            repositories.get(i).setWritePolicy(writePolicies.get(i));
        }
        this.nexusConfiguration.saveConfiguration();
    }
}

