/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.task;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepository;
import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.task.NpmTaskSupport;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.scheduling.TaskUtil;

@Named(value="NpmMetadataDeleteTask")
@Singleton
public class NpmMetadataDeleteTask
extends NpmTaskSupport<NpmRepository> {
    @Inject
    public NpmMetadataDeleteTask(NexusConfiguration nexusConfiguration) {
        super(nexusConfiguration);
    }

    @Override
    protected void doExecute(List<NpmRepository> repositories) throws Exception {
        for (NpmRepository repository : repositories) {
            TaskUtil.checkInterruption();
            try {
                if (repository instanceof NpmHostedRepository) {
                    ((NpmHostedRepository)repository).getMetadataService().deleteAllMetadata();
                    continue;
                }
                if (!(repository instanceof NpmProxyRepository)) continue;
                ((NpmProxyRepository)repository).getMetadataService().deleteAllMetadata();
            }
            catch (Exception e) {
                this.logger.info("npm repository error during delete metadata of {}", (Object)repository, (Object)e);
            }
        }
    }

    protected String getAction() {
        return "NPM-MD-DELETE";
    }

    protected String getMessage() {
        List repositories = Lists.transform(this.getAffectedRepositories(), (Function)new Function<NpmRepository, String>(){

            public String apply(NpmRepository input) {
                return input.getId();
            }
        });
        return "Delete npm metadata of repositories: " + repositories;
    }

    @Override
    protected List<NpmRepository> getAffectedRepositories() {
        if (Strings.isNullOrEmpty((String)this.getRepositoryId())) {
            return this.getRepositoryRegistry().getRepositoriesWithFacet(NpmRepository.class);
        }
        try {
            return Lists.newArrayList((Object[])new NpmRepository[]{(NpmRepository)this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryId(), NpmRepository.class)});
        }
        catch (NoSuchRepositoryException e) {
            throw new IllegalArgumentException("Delete npm metadata task misconfiguration: no npm repository with ID " + this.getRepositoryId(), e);
        }
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }
}

