/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.task;

import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepository;
import com.bolyuba.nexus.plugin.npm.task.NpmTaskSupport;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.scheduling.TaskUtil;

@Named(value="NpmHostedMetadataRebuildTask")
@Singleton
public class NpmHostedMetadataRebuildTask
extends NpmTaskSupport<NpmHostedRepository> {
    @Inject
    public NpmHostedMetadataRebuildTask(NexusConfiguration nexusConfiguration) {
        super(nexusConfiguration);
    }

    @Override
    protected void doExecute(List<NpmHostedRepository> repositories) throws Exception {
        for (NpmHostedRepository repository : repositories) {
            TaskUtil.checkInterruption();
            try {
                repository.recreateNpmMetadata();
            }
            catch (Exception e) {
                this.logger.info("Hosted npm repository error during rebuilding metadata of {}", (Object)repository, (Object)e);
            }
        }
    }

    protected String getAction() {
        return "NPM-MD-REBUILD";
    }

    protected String getMessage() {
        List repositories = Lists.transform(this.getAffectedRepositories(), (Function)new Function<NpmHostedRepository, String>(){

            public String apply(NpmHostedRepository input) {
                return input.getId();
            }
        });
        return "Rebuild hosted npm metadata of repositories: " + repositories;
    }

    @Override
    protected List<NpmHostedRepository> getAffectedRepositories() {
        if (Strings.isNullOrEmpty((String)this.getRepositoryId())) {
            return this.getRepositoryRegistry().getRepositoriesWithFacet(NpmHostedRepository.class);
        }
        try {
            return Lists.newArrayList((Object[])new NpmHostedRepository[]{(NpmHostedRepository)this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryId(), NpmHostedRepository.class)});
        }
        catch (NoSuchRepositoryException e) {
            throw new IllegalArgumentException("Rebuild hosted npm metadata task misconfiguration: no npm repository with ID " + this.getRepositoryId(), e);
        }
    }

    protected String getRepositoryFieldId() {
        return "repositoryId";
    }
}

