/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.task;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.service.internal.orient.OrientMetadataStore;
import com.bolyuba.nexus.plugin.npm.task.NpmTaskSupport;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.NexusConfiguration;

@Named(value="NpmDbBackupTask")
@Singleton
public class NpmDbBackupTask
extends NpmTaskSupport<NpmRepository> {
    private final OrientMetadataStore orientMetadataStore;

    @Inject
    public NpmDbBackupTask(NexusConfiguration nexusConfiguration, OrientMetadataStore orientMetadataStore) {
        super(nexusConfiguration);
        this.orientMetadataStore = (OrientMetadataStore)Preconditions.checkNotNull((Object)orientMetadataStore);
    }

    @Override
    protected void doExecute(List<NpmRepository> repositories) throws Exception {
        this.orientMetadataStore.backupDatabase();
    }

    @Override
    protected List<NpmRepository> getAffectedRepositories() {
        return this.getRepositoryRegistry().getRepositoriesWithFacet(NpmRepository.class);
    }

    protected String getAction() {
        return "NPM-DB-BACKUP";
    }

    protected String getMessage() {
        return "Backing up npm metadata database.";
    }
}

