/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.tarball.internal;

import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballRequest;
import com.bolyuba.nexus.plugin.npm.service.tarball.internal.TarballValidator;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class TikaPayloadValidator
extends ComponentSupport
implements TarballValidator {
    private static final String[] EXPECTED_MIME_TYPES = new String[]{"application/x-gzip", "application/gzip"};
    private final MimeSupport mimeSupport;

    @Inject
    public TikaPayloadValidator(MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    @Override
    public TarballValidator.Result validate(TarballRequest request, NpmBlob tarball) {
        try {
            List detectedMimeTypes = this.mimeSupport.detectMimeTypesListFromContent((ContentLocator)tarball);
            this.log.trace("Tika detected content of {} as '{}'", (Object)tarball.getName(), (Object)detectedMimeTypes);
            for (String expectedMimeType : EXPECTED_MIME_TYPES) {
                if (!detectedMimeTypes.contains(expectedMimeType)) continue;
                return TarballValidator.Result.VALID;
            }
            return TarballValidator.Result.INVALID;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

