/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.tarball.internal;

import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballRequest;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballSource;
import com.bolyuba.nexus.plugin.npm.service.tarball.internal.HttpTarballTransport;
import com.bolyuba.nexus.plugin.npm.service.tarball.internal.TarballValidator;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.proxy.repository.RemoteConnectionSettings;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class TarballSourceImpl
extends ComponentSupport
implements TarballSource {
    private final ApplicationDirectories applicationDirectories;
    private final HttpTarballTransport tarballTransport;
    private final Map<String, TarballValidator> validators;

    @Inject
    public TarballSourceImpl(ApplicationDirectories applicationDirectories, HttpTarballTransport tarballTransport, Map<String, TarballValidator> validators) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.tarballTransport = (HttpTarballTransport)((Object)Preconditions.checkNotNull((Object)((Object)tarballTransport)));
        this.validators = (Map)Preconditions.checkNotNull(validators);
    }

    @Override
    public NpmBlob get(NpmProxyRepository npmProxyRepository, TarballRequest tarballRequest) throws IOException {
        RemoteConnectionSettings settings;
        int fetchRetries = 1;
        if (npmProxyRepository.getRemoteStorageContext() != null && (settings = npmProxyRepository.getRemoteStorageContext().getRemoteConnectionSettings()) != null) {
            fetchRetries = settings.getRetrievalRetryCount();
        }
        boolean debug = this.log.isDebugEnabled();
        File tempFile = File.createTempFile(npmProxyRepository.getId() + "-tarball", "tgz", this.applicationDirectories.getTemporaryDirectory());
        for (int i = 0; i < fetchRetries; ++i) {
            if (debug) {
                this.log.debug("Retry {}/{} for {}@{} tarball...", new Object[]{i, fetchRetries, tarballRequest.getPackageVersion().getName(), tarballRequest.getPackageVersion().getVersion()});
            }
            try {
                NpmBlob tarball = this.tarballTransport.getTarballForVersion(npmProxyRepository, tempFile, tarballRequest.getPackageVersion());
                if (tarball == null) {
                    if (debug) {
                        this.log.debug("Tarball for {}@{} not found on {}", new Object[]{tarballRequest.getPackageVersion().getName(), tarballRequest.getPackageVersion().getVersion(), tarballRequest.getPackageVersion().getDistTarball()});
                    }
                    return null;
                }
                for (TarballValidator validator : this.validators.values()) {
                    TarballValidator.Result result = validator.validate(tarballRequest, tarball);
                    if (debug) {
                        this.log.debug("Validated tarball {}@{} :: {} found '{}' by validator {}", new Object[]{tarballRequest.getPackageVersion().getName(), tarballRequest.getPackageVersion().getVersion(), tarballRequest.getPackageVersion().getDistTarball(), result.name(), validator.getClass().getSimpleName()});
                    }
                    if (result != TarballValidator.Result.INVALID) continue;
                    tarball.delete();
                    throw new IOException("Invalid content detected: " + validator.getClass().getSimpleName());
                }
                return tarball;
            }
            catch (IOException e) {
                this.log.warn("Fetch {}/{} failed for {}@{} tarball: {}", new Object[]{i, fetchRetries, tarballRequest.getPackageVersion().getName(), tarballRequest.getPackageVersion().getVersion(), e.toString()});
                continue;
            }
        }
        return null;
    }
}

