/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.tarball.internal;

import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballRequest;
import com.bolyuba.nexus.plugin.npm.service.tarball.internal.TarballValidator;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class Sha1HashPayloadValidator
extends ComponentSupport
implements TarballValidator {
    @Override
    public TarballValidator.Result validate(TarballRequest request, NpmBlob tarball) {
        String expectedShasum = request.getPackageVersion().getDistShasum();
        if (expectedShasum != null && !expectedShasum.equals(tarball.getSha1sum())) {
            return TarballValidator.Result.INVALID;
        }
        if (expectedShasum == null) {
            return TarballValidator.Result.NEUTRAL;
        }
        return TarballValidator.Result.VALID;
    }
}

