/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.tarball.internal;

import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.util.DigesterUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class HttpTarballTransport
extends ComponentSupport {
    private static final Logger outboundRequestLog = LoggerFactory.getLogger((String)"remote.storage.outbound");
    private static final Set<Integer> NO_RETRIES_RESPONSE_CODES = ImmutableSet.of((Object)404, (Object)401, (Object)403);
    private final Hc4Provider hc4Provider;
    private final MetricsRegistry metricsRegistry;

    @Inject
    public HttpTarballTransport(Hc4Provider hc4Provider) {
        this.hc4Provider = (Hc4Provider)Preconditions.checkNotNull((Object)hc4Provider);
        this.metricsRegistry = Metrics.defaultRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NpmBlob getTarballForVersion(NpmProxyRepository npmProxyRepository, File target, PackageVersion packageVersion) throws IOException {
        HttpResponse httpResponse;
        HttpClient httpClient = this.hc4Provider.createHttpClient(npmProxyRepository.getRemoteStorageContext());
        HttpGet get = new HttpGet(packageVersion.getDistTarball());
        HttpClientContext context = new HttpClientContext();
        context.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)npmProxyRepository);
        get.addHeader("Accept", "application/x-gzip");
        Timer timer = this.timer((HttpUriRequest)get, npmProxyRepository.getRemoteUrl());
        TimerContext timerContext = timer.time();
        Stopwatch stopwatch = null;
        if (outboundRequestLog.isDebugEnabled()) {
            outboundRequestLog.debug("[{}] {} {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI()});
            stopwatch = Stopwatch.createStarted();
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)get, (HttpContext)context);
        }
        finally {
            timerContext.stop();
            if (stopwatch != null) {
                stopwatch.stop();
            }
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        if (outboundRequestLog.isDebugEnabled()) {
            outboundRequestLog.debug("[{}] {} {} -> {}; {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI(), statusLine, stopwatch});
        }
        try {
            if (statusLine.getStatusCode() == 200 && httpResponse.getEntity() != null) {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                try (BufferedOutputStream bos = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(target), md));){
                    httpResponse.getEntity().writeTo((OutputStream)bos);
                    bos.flush();
                }
                NpmBlob npmBlob = new NpmBlob(target, "application/x-gzip", packageVersion.getDistTarballFilename(), DigesterUtils.getDigestAsString((byte[])md.digest()));
                return npmBlob;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("[{}] {} {} -> unexpected: {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI(), statusLine});
            }
            if (NO_RETRIES_RESPONSE_CODES.contains(statusLine.getStatusCode())) {
                NpmBlob md = null;
                return md;
            }
            try {
                throw new IOException("Unexpected response for 'GET " + get.getURI() + "': " + statusLine);
            }
            catch (NoSuchAlgorithmException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
    }

    private Timer timer(HttpUriRequest httpRequest, String baseUrl) {
        return this.metricsRegistry.newTimer(HttpTarballTransport.class, baseUrl, httpRequest.getMethod());
    }
}

