/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.tarball;

import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.google.common.base.Preconditions;
import org.sonatype.nexus.proxy.ResourceStoreRequest;

public class TarballRequest {
    private final ResourceStoreRequest resourceStoreRequest;
    private final PackageRoot packageRoot;
    private final PackageVersion packageVersion;

    public TarballRequest(ResourceStoreRequest resourceStoreRequest, PackageRoot packageRoot, PackageVersion packageVersion) {
        this.resourceStoreRequest = (ResourceStoreRequest)Preconditions.checkNotNull((Object)resourceStoreRequest);
        this.packageRoot = (PackageRoot)Preconditions.checkNotNull((Object)packageRoot);
        this.packageVersion = (PackageVersion)Preconditions.checkNotNull((Object)packageVersion);
        Preconditions.checkArgument((!packageVersion.isIncomplete() ? 1 : 0) != 0, (String)"Incomplete tarball %s cannot be requested", (Object[])new Object[]{resourceStoreRequest.getRequestPath()});
    }

    public ResourceStoreRequest getResourceStoreRequest() {
        return this.resourceStoreRequest;
    }

    public PackageRoot getPackageRoot() {
        return this.packageRoot;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }
}

