/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal.proxy;

import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.PackageRootIterator;
import com.bolyuba.nexus.plugin.npm.service.internal.ProxyMetadataTransport;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.FileContentLocator;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientManager;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class HttpProxyMetadataTransport
extends ComponentSupport
implements ProxyMetadataTransport {
    private static final Logger outboundRequestLog = LoggerFactory.getLogger((String)"remote.storage.outbound");
    private final MetadataParser metadataParser;
    private final HttpClientManager httpClientManager;
    private final MetricsRegistry metricsRegistry;

    @Inject
    public HttpProxyMetadataTransport(MetadataParser metadataParser, HttpClientManager httpClientManager) {
        this.metadataParser = (MetadataParser)((Object)Preconditions.checkNotNull((Object)((Object)metadataParser)));
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
        this.metricsRegistry = Metrics.defaultRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageRootIterator fetchRegistryRoot(NpmProxyRepository npmProxyRepository) throws IOException {
        HttpClient httpClient = this.httpClientManager.create((ProxyRepository)npmProxyRepository, npmProxyRepository.getRemoteStorageContext());
        try {
            HttpResponse httpResponse;
            HttpGet get = new HttpGet(this.buildUri(npmProxyRepository, "-/all"));
            get.addHeader("accept", "application/json");
            HttpClientContext context = new HttpClientContext();
            context.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)npmProxyRepository);
            Timer timer = this.timer((HttpUriRequest)get, npmProxyRepository.getRemoteUrl());
            TimerContext timerContext = timer.time();
            Stopwatch stopwatch = null;
            if (outboundRequestLog.isDebugEnabled()) {
                outboundRequestLog.debug("[{}] {} {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI()});
                stopwatch = Stopwatch.createStarted();
            }
            try {
                httpResponse = httpClient.execute((HttpUriRequest)get, (HttpContext)context);
            }
            finally {
                timerContext.stop();
                if (stopwatch != null) {
                    stopwatch.stop();
                }
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            if (outboundRequestLog.isDebugEnabled()) {
                outboundRequestLog.debug("[{}] {} {} -> {}; {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI(), statusLine, stopwatch});
            }
            try {
                if (statusLine.getStatusCode() == 200) {
                    File tempFile = File.createTempFile(npmProxyRepository.getId() + "-root", "temp.json", this.metadataParser.getTemporaryDirectory());
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                    Object object = null;
                    try {
                        httpResponse.getEntity().writeTo((OutputStream)bos);
                        bos.flush();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (bos != null) {
                            if (object != null) {
                                try {
                                    bos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                bos.close();
                            }
                        }
                    }
                    this.log.debug("Registry root written out to file {}, size {} bytes", (Object)tempFile.getAbsolutePath(), (Object)tempFile.length());
                    FileContentLocator cl = new FileContentLocator(tempFile, "application/json", true);
                    object = this.metadataParser.parseRegistryRoot(npmProxyRepository.getId(), (ContentLocator)cl);
                    return object;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("[{}] {} {} -> unexpected: {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI(), statusLine});
                }
                throw new IOException("Unexpected response from registry root " + statusLine);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        finally {
            this.httpClientManager.release((ProxyRepository)npmProxyRepository, npmProxyRepository.getRemoteStorageContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageRoot fetchPackageRoot(NpmProxyRepository npmProxyRepository, String packageName, PackageRoot expired) throws IOException {
        HttpClient httpClient = this.httpClientManager.create((ProxyRepository)npmProxyRepository, npmProxyRepository.getRemoteStorageContext());
        try {
            HttpResponse httpResponse;
            block20: {
                StatusLine statusLine;
                block19: {
                    PackageRoot packageRoot;
                    HttpGet get = new HttpGet(this.buildUri(npmProxyRepository, packageName));
                    get.addHeader("accept", "application/json");
                    if (expired != null && expired.getProperties().containsKey("remote.etag")) {
                        get.addHeader("if-none-match", expired.getProperties().get("remote.etag"));
                    }
                    HttpClientContext context = new HttpClientContext();
                    context.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)npmProxyRepository);
                    Timer timer = this.timer((HttpUriRequest)get, npmProxyRepository.getRemoteUrl());
                    TimerContext timerContext = timer.time();
                    Stopwatch stopwatch = null;
                    if (outboundRequestLog.isDebugEnabled()) {
                        outboundRequestLog.debug("[{}] {} {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI()});
                        stopwatch = Stopwatch.createStarted();
                    }
                    try {
                        httpResponse = httpClient.execute((HttpUriRequest)get, (HttpContext)context);
                    }
                    finally {
                        timerContext.stop();
                        if (stopwatch != null) {
                            stopwatch.stop();
                        }
                    }
                    statusLine = httpResponse.getStatusLine();
                    if (outboundRequestLog.isDebugEnabled()) {
                        outboundRequestLog.debug("[{}] {} {} -> {}; {}", new Object[]{npmProxyRepository.getId(), get.getMethod(), get.getURI(), statusLine, stopwatch});
                    }
                    try {
                        if (statusLine.getStatusCode() != 304) break block19;
                        packageRoot = expired;
                    }
                    catch (Throwable throwable) {
                        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                        throw throwable;
                    }
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    return packageRoot;
                }
                if (statusLine.getStatusCode() != 200) break block20;
                PreparedContentLocator pcl = new PreparedContentLocator(httpResponse.getEntity().getContent(), "application/json", -1L);
                PackageRoot fresh = this.metadataParser.parsePackageRoot(npmProxyRepository.getId(), (ContentLocator)pcl);
                if (httpResponse.containsHeader("etag")) {
                    fresh.getProperties().put("remote.etag", httpResponse.getFirstHeader("etag").getValue());
                }
                PackageRoot packageRoot = fresh;
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                return packageRoot;
            }
            PackageRoot packageRoot = null;
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            return packageRoot;
        }
        finally {
            this.httpClientManager.release((ProxyRepository)npmProxyRepository, npmProxyRepository.getRemoteStorageContext());
        }
    }

    private String buildUri(NpmProxyRepository npmProxyRepository, String pathElem) {
        String registryUrl = npmProxyRepository.getRemoteUrl();
        if (registryUrl.endsWith("/")) {
            return registryUrl + pathElem;
        }
        return registryUrl + "/" + pathElem;
    }

    private Timer timer(HttpUriRequest httpRequest, String baseUrl) {
        return this.metricsRegistry.newTimer(HttpProxyMetadataTransport.class, baseUrl, httpRequest.getMethod());
    }
}

