/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal.orient;

import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.internal.orient.EntityHandlerSupport;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Throwables;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import java.util.Map;

public class PackageRootHandler
extends EntityHandlerSupport<PackageRoot> {
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new SmileFactory());

    public PackageRootHandler(ODatabaseDocumentTx db) {
        super(PackageRoot.class, db);
    }

    @Override
    protected void createSchema(OSchema schema, OClass clazz) {
        clazz.createProperty("componentId", OType.STRING);
        clazz.createProperty("repositoryId", OType.STRING);
        clazz.createProperty("name", OType.STRING);
        clazz.createProperty("description", OType.STRING);
        clazz.createProperty("properties", OType.EMBEDDEDMAP, OType.STRING);
        clazz.createProperty("raw", OType.LINK);
        clazz.createIndex(clazz.getName() + ".componentId", OClass.INDEX_TYPE.UNIQUE_HASH_INDEX, new String[]{"componentId"});
        clazz.createIndex(clazz.getName() + ".pagedRepositoryId", OClass.INDEX_TYPE.UNIQUE, new String[]{"repositoryId", "@rid"});
    }

    @Override
    protected void updateSchema(OSchema schema, OClass clazz) {
        if (clazz.getClassIndex(clazz.getName() + ".pagedRepositoryId") == null) {
            clazz.createIndex(clazz.getName() + ".pagedRepositoryId", OClass.INDEX_TYPE.UNIQUE, new String[]{"repositoryId", "@rid"});
        }
    }

    @Override
    public ODocument toDocument(PackageRoot entity, ODocument doc) {
        try {
            doc.field("componentId", (Object)entity.getComponentId());
            doc.field("repositoryId", (Object)entity.getRepositoryId());
            doc.field("name", (Object)entity.getName());
            doc.field("description", (Object)entity.getDescription());
            doc.field("properties", entity.getProperties());
            ORecord rawBytes = (ORecord)doc.field("raw");
            byte[] buf = this.objectMapper.writeValueAsBytes((Object)entity.getRaw());
            if (rawBytes == null) {
                rawBytes = new ORecordBytes(buf);
            } else {
                rawBytes.clear().fromStream(buf);
            }
            doc.field("raw", (Object)rawBytes);
            return doc;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public PackageRoot toEntity(ODocument doc) {
        try {
            String repositoryId = (String)doc.field("repositoryId", OType.STRING);
            ORecordBytes rawBytes = (ORecordBytes)doc.field("raw");
            Map raw = (Map)this.objectMapper.readValue(rawBytes.toStream(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            PackageRoot result = new PackageRoot(repositoryId, raw);
            Map properties = (Map)doc.field("properties", OType.EMBEDDEDMAP);
            result.getProperties().putAll(properties);
            return result;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

