/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal.orient;

import com.bolyuba.nexus.plugin.npm.service.internal.orient.OrientMetadataStore;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.orient.core.Orient;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.NexusInitializedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class OrientMetadataStoreLifecycle
extends ComponentSupport
implements EventSubscriber {
    private final OrientMetadataStore orientMetadataStore;

    @Inject
    public OrientMetadataStoreLifecycle(OrientMetadataStore orientMetadataStore) {
        this.orientMetadataStore = (OrientMetadataStore)Preconditions.checkNotNull((Object)orientMetadataStore);
        Orient.instance().removeShutdownHook();
    }

    @Subscribe
    public void on(NexusInitializedEvent e) throws Exception {
        this.orientMetadataStore.start();
    }

    @Subscribe
    public void on(NexusStoppedEvent e) throws Exception {
        this.log.debug("Asking npm metadata store to stop...");
        try {
            this.orientMetadataStore.stop();
        }
        catch (Exception ex) {
            this.log.warn("Problem stopping the npm metadata store", (Throwable)ex);
        }
        finally {
            this.log.debug("Asking Orient to shutdown...");
            Orient.instance().shutdown();
        }
    }
}

