/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal.orient;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataStore;
import com.bolyuba.nexus.plugin.npm.service.internal.orient.EntityHandler;
import com.bolyuba.nexus.plugin.npm.service.internal.orient.PackageRootHandler;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.common.SimpleFormat;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Singleton
@Named(value="default")
public class OrientMetadataStore
extends LifecycleSupport
implements MetadataStore {
    private static final String DB_LOCATION = "db/npm";
    private static final String BACKUP_LOCATION = "backup/npm";
    private final File databaseDirectory;
    private final File backupDirectory;
    private final Map<Class<?>, EntityHandler<?>> entityHandlers;
    private final int poolMaxSize;
    private OPartitionedDatabasePool pool;

    @Inject
    public OrientMetadataStore(ApplicationDirectories applicationDirectories, @Named(value="${nexus.npm.poolMaxSize:-100}") int poolMaxSize) {
        Preconditions.checkArgument((poolMaxSize >= 1 ? 1 : 0) != 0, (Object)"Pool max size must be greater or equal to 1");
        this.databaseDirectory = applicationDirectories.getWorkDirectory(DB_LOCATION);
        this.backupDirectory = applicationDirectories.getWorkDirectory(BACKUP_LOCATION);
        this.entityHandlers = Maps.newHashMap();
        this.poolMaxSize = poolMaxSize;
    }

    protected void doStart() throws Exception {
        String dbUri = "plocal:" + this.databaseDirectory.getAbsolutePath();
        try (ODatabaseDocumentTx db = new ODatabaseDocumentTx(dbUri);){
            if (!db.exists()) {
                OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.setValue((Object)"nothing");
                db.create();
                this.log.info("Created database: {}", (Object)this.databaseDirectory);
            } else {
                db.open("admin", "admin");
                this.log.info("Opened database: {}", (Object)db);
            }
            this.registerHandler(new PackageRootHandler(db));
        }
        this.pool = new OPartitionedDatabasePool(dbUri, "admin", "admin", this.poolMaxSize);
        this.log.info("Created pool (maxSize={}): {}", (Object)this.poolMaxSize, (Object)this.pool);
    }

    public void doStop() throws Exception {
        this.log.info("Closing pool: {}", (Object)this.pool);
        this.pool.close();
        this.pool = null;
    }

    public void backupDatabase() throws IOException {
        try (ODatabaseDocumentTx db = this.db();){
            File backupFile = this.createBackupFile();
            this.log.info("Started npm DB backup to {} (all DB write operations are frozen)", (Object)backupFile.getAbsolutePath());
            FileOutputStream outputStream = new FileOutputStream(backupFile);
            db.backup((OutputStream)outputStream, null, null, new OCommandOutputListener(){

                public void onMessage(String msg) {
                    OrientMetadataStore.this.log.debug("Backup: {}", (Object)msg);
                }
            }, 9, 0x100000);
            this.log.info("Finished npm DB backup to {}", (Object)backupFile.getAbsolutePath());
        }
    }

    private File createBackupFile() throws IOException {
        String backupFileName;
        File backupFile;
        DirSupport.mkdir((File)this.backupDirectory);
        int counter = 1;
        String timestamp = new SimpleDateFormat("yyyyMMdd.HHmmss").format(new Date());
        while ((backupFile = new File(this.backupDirectory, backupFileName = SimpleFormat.format((String)"nexus-npm-db-backup-%s-%s.zip", (Object[])new Object[]{timestamp, counter++}))).exists()) {
        }
        return backupFile;
    }

    private ODatabaseDocumentTx db() {
        this.ensureStarted();
        return this.pool.acquire();
    }

    private <T> EntityHandler<T> getHandlerFor(Class<T> schema) {
        EntityHandler<?> result = this.entityHandlers.get(schema);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Schema %s has no registered handler!", (Object[])new Object[]{schema.getName()});
        return result;
    }

    private void registerHandler(EntityHandler<?> entityHandler) {
        this.log.debug("Registering entity handler for type {}", (Object)entityHandler.getJavaType().getName());
        this.entityHandlers.put(entityHandler.getJavaType(), entityHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listPackageNames(NpmRepository repository) {
        Preconditions.checkNotNull((Object)repository);
        EntityHandler<PackageRoot> entityHandler = this.getHandlerFor(PackageRoot.class);
        Throwable throwable = null;
        try (ODatabaseDocumentTx db = this.db();){
            ArrayList arrayList;
            db.begin();
            try {
                OSQLSynchQuery query = new OSQLSynchQuery("select from " + entityHandler.getSchemaName() + " where repositoryId='" + repository.getId() + "' and @rid > ? limit 1000");
                ORecordId last = new ORecordId();
                ArrayList result = Lists.newArrayList();
                List resultset = db.query((OQuery)query, new Object[]{last});
                while (!resultset.isEmpty()) {
                    result.addAll(Lists.transform((List)resultset, (Function)new Function<ODocument, String>(){

                        public String apply(@Nullable ODocument input) {
                            return (String)input.field("name", OType.STRING);
                        }
                    }));
                    last = ((ODocument)resultset.get(resultset.size() - 1)).getIdentity();
                    resultset = db.query((OQuery)query, new Object[]{last});
                }
                arrayList = result;
            }
            catch (Throwable throwable2) {
                try {
                    db.commit();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            db.commit();
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageRoot getPackageByName(NpmRepository repository, String packageName) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)packageName);
        EntityHandler<PackageRoot> entityHandler = this.getHandlerFor(PackageRoot.class);
        Throwable throwable = null;
        try (ODatabaseDocumentTx db = this.db();){
            ODocument doc;
            block19: {
                PackageRoot packageRoot;
                db.begin();
                try {
                    doc = this.doGetPackageByName(db, entityHandler, repository, packageName);
                    if (doc != null) break block19;
                    packageRoot = null;
                }
                catch (Throwable throwable2) {
                    try {
                        db.commit();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                db.commit();
                return packageRoot;
            }
            PackageRoot packageRoot = entityHandler.toEntity(doc);
            db.commit();
            return packageRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePackages(NpmRepository repository) {
        Preconditions.checkNotNull((Object)repository);
        EntityHandler<PackageRoot> entityHandler = this.getHandlerFor(PackageRoot.class);
        Throwable throwable = null;
        try (ODatabaseDocumentTx db = this.db();){
            boolean bl;
            db.begin();
            try {
                int recordsDeleted = (Integer)db.command((OCommandRequest)new OCommandSQL("delete from " + entityHandler.getSchemaName() + " where repositoryId='" + repository.getId() + "'")).execute(new Object[0]);
                bl = recordsDeleted > 0;
            }
            catch (Throwable throwable2) {
                try {
                    db.commit();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            db.commit();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePackageByName(NpmRepository repository, String packageName) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)packageName);
        EntityHandler<PackageRoot> entityHandler = this.getHandlerFor(PackageRoot.class);
        Throwable throwable = null;
        try (ODatabaseDocumentTx db = this.db();){
            ODocument doc;
            block19: {
                boolean bl;
                db.begin();
                try {
                    doc = this.doGetPackageByName(db, entityHandler, repository, packageName);
                    if (doc != null) break block19;
                    bl = false;
                }
                catch (Throwable throwable2) {
                    try {
                        db.commit();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                db.commit();
                return bl;
            }
            db.delete((ORecord)doc);
            boolean bl = true;
            db.commit();
            return bl;
        }
    }

    @Override
    public PackageRoot replacePackage(NpmRepository repository, PackageRoot packageRoot) {
        return this.updatePackage(repository, packageRoot, false);
    }

    @Override
    public PackageRoot updatePackage(NpmRepository repository, PackageRoot packageRoot) {
        return this.updatePackage(repository, packageRoot, true);
    }

    /*
     * Exception decompiling
     */
    private PackageRoot updatePackage(NpmRepository repository, PackageRoot packageRoot, boolean overlay) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int updatePackages(NpmRepository repository, Iterator<PackageRoot> packageRootIterator) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(packageRootIterator);
        EntityHandler<PackageRoot> entityHandler = this.getHandlerFor(PackageRoot.class);
        try (ODatabaseDocumentTx db = this.db();){
            int count = 0;
            try {
                while (packageRootIterator.hasNext()) {
                    PackageRoot packageRoot = packageRootIterator.next();
                    db.begin();
                    this.doUpdatePackage(db, entityHandler, repository, packageRoot, true);
                    db.commit();
                    ++count;
                }
            }
            catch (Exception e) {
                db.rollback();
                throw Throwables.propagate((Throwable)e);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public int updatePackages(NpmRepository repository, Predicate<PackageRoot> predicate, Function<PackageRoot, PackageRoot> function) {
        int pageSize = 1000;
        int retries = 3;
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(function);
        EntityHandler<PackageRoot> entityHandler = this.getHandlerFor(PackageRoot.class);
        int count = 0;
        try (ODatabaseDocumentTx db = this.db();){
            OSQLSynchQuery query = new OSQLSynchQuery("select @rid as orid from " + entityHandler.getSchemaName() + " where repositoryId='" + repository.getId() + "' and @rid > ? limit " + 1000);
            ORecordId lastProcessedOrid = new ORecordId();
            List resultset = db.query((OQuery)query, new Object[]{lastProcessedOrid});
            int retry = 0;
            while (!resultset.isEmpty()) {
                try {
                    db.begin();
                    for (ODocument d : resultset) {
                        lastProcessedOrid = (ORID)d.field("orid", ORID.class);
                        ODocument npmDoc = (ODocument)db.load((ORID)lastProcessedOrid);
                        if (npmDoc == null) continue;
                        PackageRoot root = entityHandler.toEntity(npmDoc);
                        if (predicate != null && !predicate.apply((Object)root)) continue;
                        root = (PackageRoot)function.apply((Object)root);
                        db.save((ORecord)entityHandler.toDocument(root, npmDoc));
                        ++count;
                    }
                    db.commit();
                    retry = 0;
                }
                catch (OConcurrentModificationException e) {
                    db.rollback();
                    if (++retry < 3) {
                        this.log.info("Failed update on {} packages for repository {} due to concurrent access to record {}, retrying {}/{}", new Object[]{1000, repository, e.getRid(), retry, 3});
                    }
                    retry = 0;
                    this.log.info("Failed update {} times on {} packages for repository {} due to concurrent access to record {}, skipping page", new Object[]{3, 1000, repository, e.getRid()});
                }
                if (retry != 0) continue;
                resultset = db.query((OQuery)query, new Object[]{lastProcessedOrid});
            }
        }
        return count;
    }

    private ODocument doGetPackageByName(ODatabaseDocumentTx db, EntityHandler<PackageRoot> entityHandler, NpmRepository repository, String packageName) {
        List entries = db.query((OQuery)new OSQLSynchQuery("select * from " + entityHandler.getSchemaName() + " where componentId='" + repository.getId() + ":" + packageName + "'"), new Object[0]);
        Iterator iterator = entries.iterator();
        if (iterator.hasNext()) {
            ODocument entry = (ODocument)iterator.next();
            return entry;
        }
        return null;
    }

    private PackageRoot doUpdatePackage(ODatabaseDocumentTx db, EntityHandler<PackageRoot> entityHandler, NpmRepository repository, PackageRoot packageRoot, boolean overlay) {
        ODocument doc = this.doGetPackageByName(db, entityHandler, repository, packageRoot.getName());
        if (doc == null) {
            doc = db.newInstance(entityHandler.getSchemaName());
        } else if (overlay) {
            PackageRoot existing = entityHandler.toEntity(doc);
            existing.overlay(packageRoot);
            db.save((ORecord)entityHandler.toDocument(existing, doc));
            return existing;
        }
        db.save((ORecord)entityHandler.toDocument(packageRoot, doc));
        return packageRoot;
    }
}

