/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal.orient;

import com.bolyuba.nexus.plugin.npm.service.internal.orient.EntityHandler;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import java.util.Locale;

public abstract class EntityHandlerSupport<T>
implements EntityHandler<T> {
    private final Class<T> type;
    private final String schemaName;
    private final OClass otype;

    protected EntityHandlerSupport(Class<T> type, ODatabaseDocumentTx db) {
        this.type = (Class)Preconditions.checkNotNull(type);
        this.schemaName = type.getSimpleName().toLowerCase(Locale.US);
        this.otype = this.maybeCreateSchema(db);
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public Class<T> getJavaType() {
        return this.type;
    }

    @Override
    public OClass getOrientType() {
        return this.otype;
    }

    protected OClass maybeCreateSchema(ODatabaseDocumentTx db) {
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass clazz = schema.getClass(this.getSchemaName());
        if (clazz == null) {
            clazz = schema.createClass(this.getSchemaName());
            this.createSchema((OSchema)schema, clazz);
        } else {
            this.updateSchema((OSchema)schema, clazz);
        }
        return clazz;
    }

    protected abstract void createSchema(OSchema var1, OClass var2);

    protected abstract void updateSchema(OSchema var1, OClass var2);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "type=" + this.type + ", schemaName='" + this.schemaName + '\'' + '}';
    }
}

