/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.bolyuba.nexus.plugin.npm.service.ProxyMetadataService;
import com.bolyuba.nexus.plugin.npm.service.internal.GeneratorWithStoreSupport;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataStore;
import com.bolyuba.nexus.plugin.npm.service.internal.PackageRootIterator;
import com.bolyuba.nexus.plugin.npm.service.internal.ProxyMetadataTransport;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballRequest;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.ProxyMode;

public class ProxyMetadataServiceImpl
extends GeneratorWithStoreSupport<NpmProxyRepository>
implements ProxyMetadataService {
    private static final String REGISTRY_ROOT_PACKAGE_NAME = "-";
    private final Object registryRootUpdateLock = new Object();
    private final ProxyMetadataTransport proxyMetadataTransport;
    private static final Pattern TARBALL_PATH_PATTERN = Pattern.compile("/([[a-z][A-Z][0-9]-_\\.]+)/-/([[a-z][A-Z][0-9]-_\\.]+\\.tgz)");

    public ProxyMetadataServiceImpl(NpmProxyRepository npmProxyRepository, MetadataStore metadataStore, ProxyMetadataTransport proxyMetadataTransport, MetadataParser metadataParser) {
        super(npmProxyRepository, metadataParser, metadataStore);
        this.proxyMetadataTransport = (ProxyMetadataTransport)Preconditions.checkNotNull((Object)proxyMetadataTransport);
    }

    @Override
    public boolean deleteAllMetadata() {
        this.log.info("Deleting all proxied npm metadata from {}", (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
        return this.metadataStore.deletePackages((NpmRepository)this.getNpmRepository());
    }

    @Override
    public boolean deletePackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName, (Object)"null package name");
        this.log.info("Deleting proxied npm package {} metadata from {}", (Object)packageName, (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
        return this.metadataStore.deletePackageByName((NpmRepository)this.getNpmRepository(), packageName);
    }

    @Override
    public boolean expireMetadataCaches(PackageRequest request) {
        Preconditions.checkNotNull((Object)request);
        if (request.isPackage()) {
            PackageRoot packageRoot = this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), request.getName());
            if (packageRoot == null) {
                return false;
            }
            this.log.info("Expiring package root {} in repository {}", (Object)request.getName(), (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
            packageRoot.getProperties().put("remote.expired", Boolean.TRUE.toString());
            this.metadataStore.updatePackage((NpmRepository)this.getNpmRepository(), packageRoot);
            return true;
        }
        PackageRoot registryRoot = this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), REGISTRY_ROOT_PACKAGE_NAME);
        if (registryRoot != null) {
            this.log.info("Expiring registry root of {}", (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
            registryRoot.getProperties().put("remote.expired", Boolean.TRUE.toString());
            this.metadataStore.updatePackage((NpmRepository)this.getNpmRepository(), registryRoot);
        }
        int count = this.metadataStore.updatePackages((NpmRepository)this.getNpmRepository(), null, new Function<PackageRoot, PackageRoot>(){

            public PackageRoot apply(@Nullable PackageRoot input) {
                input.getProperties().put("remote.expired", Boolean.TRUE.toString());
                return input;
            }
        });
        this.log.info("Expired registry root of {} with {} packages", (Object)((NpmProxyRepository)this.getNpmRepository()).getId(), (Object)count);
        return count > 0;
    }

    @Override
    public PackageRoot consumeRawPackageRoot(PackageRoot packageRoot) {
        Preconditions.checkNotNull((Object)packageRoot);
        return this.metadataStore.updatePackage((NpmRepository)this.getNpmRepository(), packageRoot);
    }

    @Override
    @Nullable
    public TarballRequest createTarballRequest(ResourceStoreRequest request) throws IOException {
        Preconditions.checkNotNull((Object)request);
        Matcher matcher = TARBALL_PATH_PATTERN.matcher(request.getRequestPath());
        TarballRequest tarballRequest = null;
        if (matcher.matches()) {
            String packageName = matcher.group(1);
            String tarballFilename = matcher.group(2);
            tarballRequest = this.requestTarball(request, this.mayUpdatePackageRoot(packageName, true), tarballFilename);
            if (tarballRequest == null && !request.isRequestLocalOnly()) {
                tarballRequest = this.requestTarball(request, this.mayUpdatePackageRoot(packageName, false), tarballFilename);
            }
        } else {
            this.log.debug("Not a tarball request: {}", (Object)request.getRequestPath());
        }
        return tarballRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PackageRootIterator doGenerateRegistryRoot(PackageRequest request) throws IOException {
        if (request.getPath().endsWith("/") || !request.getStoreRequest().isRequestLocalOnly()) {
            PackageRoot registryRoot = this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), REGISTRY_ROOT_PACKAGE_NAME);
            long now = System.currentTimeMillis();
            if (registryRoot == null || this.isExpired(registryRoot, now)) {
                Object object = this.registryRootUpdateLock;
                synchronized (object) {
                    registryRoot = this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), REGISTRY_ROOT_PACKAGE_NAME);
                    if (registryRoot == null || this.isExpired(registryRoot, now)) {
                        if (registryRoot == null) {
                            this.log.info("Registry root {} initial fetch", (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
                        } else {
                            this.log.info("Registry root {} expired", (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
                        }
                        if (this.isRemoteAccessAllowed()) {
                            try (PackageRootIterator packageRootIterator = this.proxyMetadataTransport.fetchRegistryRoot((NpmProxyRepository)this.getNpmRepository());){
                                int count = this.metadataStore.updatePackages((NpmRepository)this.getNpmRepository(), packageRootIterator);
                                this.log.info("Registry root {} update successful ({} packages)", (Object)((NpmProxyRepository)this.getNpmRepository()).getId(), (Object)count);
                            }
                            catch (Exception e) {
                                this.log.warn("Registry root {} update failed: ", (Object)((NpmProxyRepository)this.getNpmRepository()).getId(), (Object)e.toString());
                                throw Throwables.propagate((Throwable)e);
                            }
                            if (registryRoot == null) {
                                HashMap versions = Maps.newHashMap();
                                versions.put("0.0.0", "latest");
                                HashMap distTags = Maps.newHashMap();
                                distTags.put("latest", "0.0.0");
                                HashMap raw = Maps.newHashMap();
                                raw.put("name", REGISTRY_ROOT_PACKAGE_NAME);
                                raw.put("description", "NX registry root package");
                                raw.put("versions", versions);
                                raw.put("dist-tags", distTags);
                                registryRoot = new PackageRoot(((NpmProxyRepository)this.getNpmRepository()).getId(), raw);
                            }
                            registryRoot.getProperties().put("remote.expired", Boolean.FALSE.toString());
                            registryRoot.getProperties().put("remote.cached", Long.toString(now));
                            this.metadataStore.updatePackage((NpmRepository)this.getNpmRepository(), registryRoot);
                        } else {
                            this.log.info("Registry root {} update not allowed", (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
                        }
                    }
                }
            }
        }
        return super.doGenerateRegistryRoot(request);
    }

    @Override
    @Nullable
    protected PackageRoot doGeneratePackageRoot(PackageRequest request) throws IOException {
        return this.mayUpdatePackageRoot(request.getName(), request.getStoreRequest().isRequestLocalOnly());
    }

    private TarballRequest requestTarball(ResourceStoreRequest request, PackageRoot packageRoot, String tarballFilename) {
        String path = request.getRequestPath();
        if (packageRoot != null) {
            this.log.debug("Looking up package {} version for tarball request: {}", (Object)packageRoot.getName(), (Object)path);
            for (PackageVersion version : packageRoot.getVersions().values()) {
                if (!version.getDistTarball().endsWith(tarballFilename)) continue;
                this.log.debug("Package {} version {} matched for tarball request: {}", new Object[]{packageRoot.getName(), version.getVersion(), path});
                return new TarballRequest(request, packageRoot, version);
            }
            this.log.debug("Package not found in metadata: {}", (Object)path);
        } else {
            this.log.debug("Package metadata not available: {}", (Object)path);
        }
        return null;
    }

    private PackageRoot mayUpdatePackageRoot(String packageName, boolean localOnly) throws IOException {
        long now = System.currentTimeMillis();
        PackageRoot packageRoot = this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), packageName);
        if (this.isRemoteAccessAllowed() && !localOnly && (packageRoot == null || this.isExpired(packageRoot, now))) {
            packageRoot = this.proxyMetadataTransport.fetchPackageRoot((NpmProxyRepository)this.getNpmRepository(), packageName, packageRoot);
            if (packageRoot == null) {
                return null;
            }
            ((NpmProxyRepository)this.getNpmRepository()).getNotFoundCache().removeWithChildren("/" + packageName);
            packageRoot.getProperties().put("remote.expired", Boolean.FALSE.toString());
            packageRoot.getProperties().put("remote.cached", Long.toString(now));
            return this.metadataStore.replacePackage((NpmRepository)this.getNpmRepository(), packageRoot);
        }
        return packageRoot;
    }

    private boolean isExpired(PackageRoot packageRoot, long now) {
        boolean result;
        if (!REGISTRY_ROOT_PACKAGE_NAME.equals(packageRoot.getName()) && packageRoot.isIncomplete()) {
            this.log.trace("EXPIRED: package {} is incomplete", (Object)packageRoot.getName());
            packageRoot.getProperties().remove("remote.etag");
            return true;
        }
        if (!((NpmProxyRepository)this.getNpmRepository()).isItemAgingActive()) {
            this.log.trace("EXPIRED: package {} owning repository item aging is inactive", (Object)packageRoot.getName());
            return true;
        }
        if (Boolean.TRUE.toString().equals(packageRoot.getProperties().get("remote.expired"))) {
            this.log.trace("EXPIRED: package {} flagged as expired", (Object)packageRoot.getName());
            return true;
        }
        if (((NpmProxyRepository)this.getNpmRepository()).getItemMaxAge() < 0) {
            this.log.trace("NOT-EXPIRED: package {} owning repository {} has negative item max age", (Object)packageRoot.getName(), (Object)((NpmProxyRepository)this.getNpmRepository()).getId());
            return false;
        }
        long remoteCached = packageRoot.getProperties().containsKey("remote.cached") ? Long.valueOf(packageRoot.getProperties().get("remote.cached")) : now;
        boolean bl = result = now - remoteCached > (long)((NpmProxyRepository)this.getNpmRepository()).getItemMaxAge() * 60L * 1000L;
        if (result) {
            this.log.trace("EXPIRED: package {} is too old", (Object)packageRoot.getName());
        } else {
            this.log.trace("NOT-EXPIRED: package {} is fresh", (Object)packageRoot.getName());
        }
        return result;
    }

    private boolean isRemoteAccessAllowed() {
        ProxyMode proxyMode = ((NpmProxyRepository)this.getNpmRepository()).getProxyMode();
        if (proxyMode != null) {
            return proxyMode.shouldProxy();
        }
        return false;
    }
}

