/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.group.NpmGroupRepository;
import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepository;
import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.service.GroupMetadataService;
import com.bolyuba.nexus.plugin.npm.service.HostedMetadataService;
import com.bolyuba.nexus.plugin.npm.service.MetadataServiceFactory;
import com.bolyuba.nexus.plugin.npm.service.ProxyMetadataService;
import com.bolyuba.nexus.plugin.npm.service.internal.GroupMetadataServiceImpl;
import com.bolyuba.nexus.plugin.npm.service.internal.HostedMetadataServiceImpl;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataStore;
import com.bolyuba.nexus.plugin.npm.service.internal.ProxyMetadataServiceImpl;
import com.bolyuba.nexus.plugin.npm.service.internal.ProxyMetadataTransport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class MetadataServiceFactoryImpl
extends ComponentSupport
implements MetadataServiceFactory {
    private final MetadataStore metadataStore;
    private final MetadataParser metadataParser;
    private final ProxyMetadataTransport proxyMetadataTransport;

    @Inject
    public MetadataServiceFactoryImpl(MetadataStore metadataStore, MetadataParser metadataParser, ProxyMetadataTransport proxyMetadataTransport) {
        this.metadataStore = (MetadataStore)Preconditions.checkNotNull((Object)metadataStore);
        this.metadataParser = (MetadataParser)((Object)Preconditions.checkNotNull((Object)((Object)metadataParser)));
        this.proxyMetadataTransport = (ProxyMetadataTransport)Preconditions.checkNotNull((Object)proxyMetadataTransport);
    }

    @VisibleForTesting
    public ProxyMetadataTransport getProxyMetadataTransport() {
        return this.proxyMetadataTransport;
    }

    @Override
    public HostedMetadataService createHostedMetadataService(NpmHostedRepository npmHostedRepository) {
        return new HostedMetadataServiceImpl(npmHostedRepository, this.metadataStore, this.metadataParser);
    }

    @Override
    public ProxyMetadataService createProxyMetadataService(NpmProxyRepository npmProxyRepository) {
        return new ProxyMetadataServiceImpl(npmProxyRepository, this.metadataStore, this.getProxyMetadataTransport(), this.metadataParser);
    }

    @Override
    public GroupMetadataService createGroupMetadataService(NpmGroupRepository npmGroupRepository) {
        return new GroupMetadataServiceImpl(npmGroupRepository, this.metadataParser);
    }
}

