/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.bolyuba.nexus.plugin.npm.service.internal.PackageRootIterator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.proxy.item.AbstractContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.util.DigesterUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class MetadataParser
extends ComponentSupport {
    private final File temporaryDirectory;
    private final ObjectMapper objectMapper;

    @Inject
    public MetadataParser(ApplicationDirectories applicationDirectories) {
        this(applicationDirectories.getTemporaryDirectory());
    }

    @VisibleForTesting
    public MetadataParser(File temporaryDirectory) {
        this.temporaryDirectory = (File)Preconditions.checkNotNull((Object)temporaryDirectory);
        this.objectMapper = new ObjectMapper();
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public PackageRootIterator parseRegistryRoot(String repositoryId, ContentLocator contentLocator) throws IOException {
        Preconditions.checkNotNull((Object)repositoryId);
        Preconditions.checkNotNull((Object)contentLocator);
        Preconditions.checkArgument((boolean)"application/json".equals(contentLocator.getMimeType()), (Object)"JSON is expected inout!");
        return new ParsingPackageRootIterator(repositoryId, this.objectMapper.getFactory().createParser(contentLocator.getContent()));
    }

    public PackageRoot parsePackageRoot(String repositoryId, ContentLocator contentLocator) throws IOException {
        Preconditions.checkNotNull((Object)repositoryId);
        Preconditions.checkNotNull((Object)contentLocator);
        Preconditions.checkArgument((boolean)"application/json".equals(contentLocator.getMimeType()), (Object)"JSON is expected inout!");
        try (JsonParser parser = this.objectMapper.getFactory().createParser(contentLocator.getContent());){
            PackageRoot packageRoot = this.parsePackageRoot(repositoryId, parser);
            Preconditions.checkArgument((!packageRoot.isIncomplete() ? 1 : 0) != 0, (Object)"Wrong API use, incomplete package roots should not be consumed this way!");
            PackageRoot packageRoot2 = packageRoot;
            return packageRoot2;
        }
    }

    public RegistryRootContentLocator produceRegistryRoot(PackageRootIterator packageRootIterator) throws IOException {
        Preconditions.checkNotNull((Object)packageRootIterator);
        return new RegistryRootContentLocator(this, packageRootIterator);
    }

    @Nullable
    public StringContentLocator produceShrinkedPackageRoot(PackageRoot root) throws IOException {
        if (root == null) {
            return null;
        }
        String jsonString = this.objectMapper.writeValueAsString((Object)root.getRaw());
        return new StringContentLocator(jsonString, "application/json");
    }

    @Nullable
    public StringContentLocator producePackageRoot(PackageRoot root) throws IOException {
        if (root == null) {
            return null;
        }
        String jsonString = this.objectMapper.writeValueAsString((Object)root.getRaw());
        return new StringContentLocator(jsonString, "application/json");
    }

    @Nullable
    public StringContentLocator producePackageVersion(PackageVersion version) throws IOException {
        if (version == null) {
            return null;
        }
        String jsonString = this.objectMapper.writeValueAsString((Object)version.getRaw());
        return new StringContentLocator(jsonString, "application/json");
    }

    private PackageRoot parsePackageRoot(String repositoryId, JsonParser parser) throws IOException {
        HashMap raw = Maps.newHashMap();
        HashMap attachments = Maps.newHashMap();
        Preconditions.checkArgument((parser.nextToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)"Unexpected input %s, expected %s", (Object[])new Object[]{parser.getCurrentToken(), JsonToken.START_OBJECT});
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            if ("_attachments".equals(fieldName)) {
                this.parsePackageAttachments(parser, attachments);
                continue;
            }
            JsonToken token = parser.nextValue();
            if (token == JsonToken.START_OBJECT) {
                raw.put(fieldName, parser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){}));
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                raw.put(fieldName, parser.readValueAs((TypeReference)new TypeReference<List<Object>>(){}));
                continue;
            }
            switch (token) {
                case VALUE_NULL: {
                    raw.put(fieldName, null);
                    break;
                }
                case VALUE_FALSE: {
                    raw.put(fieldName, Boolean.FALSE);
                    break;
                }
                case VALUE_TRUE: {
                    raw.put(fieldName, Boolean.TRUE);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    raw.put(fieldName, parser.getValueAsInt());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    raw.put(fieldName, parser.getValueAsDouble());
                    break;
                }
                case VALUE_STRING: {
                    raw.put(fieldName, parser.getValueAsString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected token: " + token);
                }
            }
            raw.put(fieldName, parser.getValueAsString());
        }
        PackageRoot result = new PackageRoot(repositoryId, raw);
        if (!attachments.isEmpty()) {
            result.getAttachments().putAll(attachments);
        }
        return result;
    }

    @VisibleForTesting
    void parsePackageAttachments(JsonParser parser, Map<String, NpmBlob> attachments) throws IOException {
        Preconditions.checkArgument((parser.nextToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)"Unexpected input %s, expected %s", (Object[])new Object[]{parser.getCurrentToken(), JsonToken.START_OBJECT});
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            NpmBlob attachment = this.parsePackageAttachment(parser);
            if (attachment == null) continue;
            attachments.put(attachment.getName(), attachment);
        }
    }

    @Nullable
    private NpmBlob parsePackageAttachment(JsonParser parser) throws IOException {
        String name = parser.getCurrentName();
        String contentType = "application/octet-stream";
        long length = -1L;
        String sha1hash = null;
        File file = null;
        boolean stub = false;
        Preconditions.checkArgument((parser.nextToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)"Unexpected input %s, expected %s", (Object[])new Object[]{parser.getCurrentToken(), JsonToken.START_OBJECT});
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            parser.nextValue();
            if ("content_type".equals(fieldName)) {
                contentType = parser.getValueAsString();
                continue;
            }
            if ("stub".equals(fieldName)) {
                stub = parser.getValueAsBoolean();
                continue;
            }
            if ("length".equals(fieldName)) {
                length = parser.getValueAsLong();
                continue;
            }
            if (!"data".equals(fieldName)) continue;
            file = File.createTempFile("npm_attachment", "temp", this.temporaryDirectory);
            byte[] binaryValue = parser.getBinaryValue();
            sha1hash = DigesterUtils.getSha1Digest((byte[])binaryValue);
            Files.write((byte[])parser.getBinaryValue(), (File)file);
        }
        if (stub || file == null) {
            return null;
        }
        if (length != -1L) {
            Preconditions.checkArgument((file.length() == length ? 1 : 0) != 0, (Object)"Invalid content length!");
        }
        return new NpmBlob(file, contentType, name, sha1hash);
    }

    private static class RegistryRootContentLocator
    extends AbstractContentLocator
    implements Iterator<ByteSource> {
        private final MetadataParser metadataParser;
        private final PackageRootIterator packageRootIterator;
        private boolean first;

        protected RegistryRootContentLocator(MetadataParser metadataParser, PackageRootIterator packageRootIterator) {
            super("application/json", false, -1L);
            this.metadataParser = metadataParser;
            this.packageRootIterator = packageRootIterator;
            this.first = true;
        }

        public InputStream getContent() throws IOException {
            return ByteSource.concat((Iterator)this).openStream();
        }

        @Override
        public boolean hasNext() {
            return this.first || this.packageRootIterator.hasNext();
        }

        @Override
        public ByteSource next() {
            try {
                ArrayList sources = Lists.newArrayList();
                if (this.first) {
                    this.first = false;
                    sources.add(ByteSource.wrap((byte[])"{".getBytes(Charsets.UTF_8)));
                }
                if (this.packageRootIterator.hasNext()) {
                    PackageRoot packageRoot = (PackageRoot)this.packageRootIterator.next();
                    sources.add(ByteSource.wrap((byte[])("\"" + packageRoot.getName() + "\":").getBytes(Charsets.UTF_8)));
                    sources.add(ByteSource.wrap((byte[])this.metadataParser.produceShrinkedPackageRoot(packageRoot).getByteArray()));
                }
                if (!this.packageRootIterator.hasNext()) {
                    sources.add(ByteSource.wrap((byte[])"}".getBytes(Charsets.UTF_8)));
                } else {
                    sources.add(ByteSource.wrap((byte[])",".getBytes(Charsets.UTF_8)));
                }
                return ByteSource.concat((Iterable)sources);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }

    private class ParsingPackageRootIterator
    implements PackageRootIterator {
        private final String repositoryId;
        private final JsonParser parser;
        private PackageRoot nextPackageRoot;

        private ParsingPackageRootIterator(String repositoryId, JsonParser parser) {
            this.repositoryId = repositoryId;
            this.parser = parser;
            this.nextPackageRoot = this.getNext();
        }

        @Override
        public void close() throws IOException {
            this.parser.close();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.nextPackageRoot != null;
            if (!hasNext) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            return hasNext;
        }

        @Override
        public PackageRoot next() {
            PackageRoot next = this.nextPackageRoot;
            this.nextPackageRoot = this.getNext();
            return next;
        }

        private PackageRoot getNext() {
            try {
                while (this.parser.nextToken() != null) {
                    if (this.parser.getCurrentToken() != JsonToken.FIELD_NAME || this.parser.getCurrentName().startsWith("_")) continue;
                    return MetadataParser.this.parsePackageRoot(this.repositoryId, this.parser);
                }
                return null;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported");
        }
    }
}

